/* stdio.h standard header
 * $Version: 1.14 $
 * Copyright (c) 1988-93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _STDIO
#define _STDIO

#include <yvals.h>
#include <_align.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * [1]-STANDARD C DEFINITIONS
 */
#if (_model_rmx) || (_model_blue) || (_model_posix) || (_model_green)

/*
 * macro definitions
 */

#define _IOFBF          0x00 /* neither line nor char buffering */
#define _IOLBF          0x40
#define _IONBF          0x04
#define BUFSIZ          512
#define EOF             (-1)
#define FILENAME_MAX    _FNAMAX
#define FOPEN_MAX       _FOPMAX
#define L_tmpnam        _TNAMAX
#define TMP_MAX         4096
#define SEEK_SET        0
#define SEEK_CUR        1
#define SEEK_END        2

/*
 * non-standard macro definitions
 */
					
#define P_tmpdir        "\\"
#define _IOREAD         0x01
#define _IOWRT          0x02
#define _IOMYBUF        0x08
#define _IOEOF          0x10
#define _IOERR          0x20
#define _IOSTRG         0x40
#define _IORW           0x80
#define _IODIRTY        0x200
#define _IO_STD_STREAM  0x1000

/*
 * type definitions
 */

#ifndef _SIZET
#define _SIZET
typedef _Sizet size_t;
#endif
#ifndef _FPOST
#define _FPOST
typedef _Fpost fpos_t;
#endif
#ifndef _VALIST
#define _VALIST
typedef _Valist va_list;
#endif

#ifndef _FILE
#define _FILE
struct _iobuf {
    _ptrdef(unsigned char, _ptr)
    _aligndef(int, _cnt)
    _ptrdef(unsigned char, _base)
    _aligndef(int, _flag)
    _aligndef(int, _fd)                     /* File descriptor number */
    _aligndef(int, _size)                   /* File buffer size */
    _ptrdef(char, _temp_name)               /* Temporary file name */
    _ptrdef(void, _sem)                     /* Semaphore */
    _ptrdef(struct _iobuf, _next_stream)    /* Pointer to the next stream */
};
typedef struct _iobuf FILE;
#endif /* _FILE */

/* 
 * Special declarations needed for Microsoft C++ libraries
 */
#if defined(_MSC_VER)
extern FILE __near __cdecl _iob[];
int  __cdecl  _fileno(FILE  *);
#endif

/*
 * stdin, stdout, stderr definitions
 */

#include <reent.h>

#define stdin   (&_stdio_ptr()->_stdin)
#define stdout  (&_stdio_ptr()->_stdout)
#define stderr  (&_stdio_ptr()->_stderr)

/*
 * function prototypes
 */

void        _Pascal clearerr(FILE *);
int         _Pascal fclose(FILE *);
int         _Pascal feof(FILE *);
int         _Pascal ferror(FILE *);
int         _Pascal fflush(FILE *);
int         _Pascal fgetc(FILE *);
int         _Pascal fgetpos(FILE *, fpos_t *);
char      * _Pascal fgets(char *, int, FILE *);
FILE      * _Pascal fopen(const char *, const char *);
int         _Cdecl fprintf(FILE *, const char *, ...);
int         _Pascal fputc(int, FILE *);
int         _Pascal fputchar(int);
int         _Pascal fputs(const char *, FILE *);
size_t      _Pascal fread(void *, size_t, size_t, FILE *);
FILE      * _Pascal freopen(const char *, const char *, FILE *);
int         _Cdecl fscanf(FILE *, const char *, ...);
int         _Pascal fseek(FILE *, long32, int);
int         _Pascal fsetpos(FILE *, const fpos_t *);
FILE      * _Pascal _fsopen(const char *, const char *, int);
long32      _Pascal ftell(FILE *);
size_t      _Pascal fwrite(const void *, size_t, size_t, FILE *);
int         _Pascal getc(FILE *);
int         _Pascal getchar(void);
int         _Pascal getopt(int, char **, const char *);
char      * _Pascal gets(char *);
void        _Pascal perror(const char *);
int         _Cdecl printf(const char *, ...);
int         _Pascal putc(int, FILE *);
int         _Pascal putchar(int);
int         _Pascal puts(const char *);
int         _Pascal remove(const char *);
int         _Pascal rename(const char *, const char *);
void        _Pascal rewind(FILE *);
int         _Cdecl scanf(const char *, ...);
void        _Pascal setbuf(FILE *, char *);
int         _Pascal setvbuf(FILE *, char *, int, size_t);
int         _Cdecl sprintf(char *, const char *, ...);
int         _Cdecl sscanf(const char *, const char *, ...);
FILE      * _Pascal tmpfile(void);
char      * _Pascal tmpnam(char *);
int         _Pascal ungetc(int, FILE *);
int         _Pascal vfprintf(FILE *, const char *, va_list);
int         _Pascal vprintf( const char *, va_list);
int         _Pascal vsprintf(char *, const char *, va_list);

/*
 * non-standard function protoypes
 */

int         _Pascal fcloseall(void);
FILE      * _Pascal fdopen(int, const char *);
int         _Pascal fgetchar(void);
int         _Pascal fileno(FILE *);
int         _Pascal flushall(void);
int         _Pascal getw(FILE *);
int         _Pascal putw(int, FILE *);
int         _Pascal rmtmp(void);
char      * _Pascal tempnam(char *, const char *);

/*
 * macro overrides 
 */

#define feof(f)    ((f)->_flag & _IOEOF)
#define ferror(f)  ((f)->_flag & _IOERR)
#define fgetchar() fgetc(stdin)
#define fileno(f)  ((f)->_fd)
#define _ungetc_

#ifdef __INT32__
#define getc(_s)        (((((_s)->_cnt) > 0) && (((_s)->_cnt) < ((_s)->_size))) \
? (((_s)->_cnt--), (unsigned char)(*(_s)->_ptr++)) : ((getc)(_s)))
#define putc(_c,_s)     (((((_s)->_cnt) > 0) && (((_s)->_cnt) < ((_s)->_size))) \
? (((_s)->_cnt--), (*((_s)->_ptr++)=(unsigned char)(_c))) : ((putc)(_c,_s)))
#endif

#endif /* rmx, blue, posix and green */

/*
 * [2]-COMMON DEFINITIONS THAT ARE NOT STANDARD C DEFINITIONS
 */
#if (_model_blue) || (_model_posix) || (_model_green)
#endif /* blue, posix and green */

/*
 * [3]-COMMON NETWORK DEFINITIONS (same as _UNIX_SOURCE)
 */
#if (_model_blue) || (_model_green)
#endif /* blue and green */

/*
 * [4]-COMMON NON-POSIX DEFINITIONS
 */
#if (_model_rmx) || (_model_blue)
#endif /* rmx and blue */

/*
 * [5]-POSIX SPECIFIC DEFINITIONS (same as _POSIX_SOURCE)
 */
#if (_model_posix) || (_model_green)

#include <stdlib.h>

/*
 * POSIX function prototypes
 */

int         _Pascal pclose(FILE *);
FILE      * _Pascal popen(char *, char *);

#endif /* posix and green */

/*
 * [6]-RMX SPECIFIC DEFINITIONS
 */
#if (_model_rmx)
#endif /* rmx */

/*
 * [7]-NON-POSIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_blue)
#endif /* blue */

/*
 * [8]-UNIX/UNIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_green)
#endif /* green */

#ifdef __cplusplus
}
#endif

#include <_restore.h>

#endif /* _STDIO */
