#include "types.h"
#include "memblock.h"
#include "ether.h"
#include <malloc.h>
#include <memory.h>
#include <stdio.h>

ether_packet *unpack_ether_header(memblock *mb)
{
  ether_packet *result;
  int ieee802 = 0;
  
  result = (ether_packet *) malloc(sizeof(ether_packet));

  result->length=0;
  result->data=mb;
  /* extract destination adress */
  memcpy ((void *) (result->dest_addr), (void *) (mb->data+0), 6);
  /*  swap_ether_addr (result->dest_addr); */

  /* extract source adress */
  memcpy ((void *) (result->src_addr), (void *) (mb->data+6), 6);
  /*  swap_ether_addr (result->src_addr); */

  /* extract type code */
  result->type = SWAP16(*((u16 *)(mb->data+12)));
  
  /* Is this ethernet or 802.3? */
  if (result->type < 1536) {
    /* We can save the length we get from the 802.3 header. */
    result->length=result->type;
    /* IEEE 802.3 - so get the real type field and remember to skip
       the 802.2 header when copying the data. */
    result->type = SWAP16(*((u16 *)(mb->data+20)));
    ieee802 = 1;
  } else {
    /* True ethernet - don't try to skip an 802.2 header later. */
    ieee802 = 0;
  }

  result->payload_offset = ieee802 ? 22 : 14;
  result->payload_start = result->data->data+result->payload_offset;

  /* Hack to get the length: if no ieee802 length available
     try to get high-level protocol length (ewwww) */
  if (!ieee802) {
    switch (result->type) {
    case 0x800: /* IP */
      /* Grab it from the IP header. */
      result->length= SWAP16(*((u16 *)(mb->data+16))) + 14;
      break;
    case 0x806: /* ARP */
      result->length=42; /* 14-byte header plus 28-byte data */      
      break;
    default:
      fprintf(stderr, "Unknown packet type received (%d)\n", result->type);
      result->length=14; /* who the fuck knows... */
    }
  }
  return result;
}


memblock *pack_ether_header(ether_packet *ep)
{
  memblock *result=ep->data;

  /* pack destination adress */
  memcpy ((void *) (result->data+0), (void *) (ep->dest_addr), 6);
  /*  swap_ether_addr (result->dest_addr); */

  /* pack source adress */
  memcpy ((void *) (result->data+6), (void *) (ep->src_addr), 6);
  /*  swap_ether_addr (result->src_addr); */

  /* pack type */
  *(u16 *)(result->data+12) = SWAP16(ep->type);

  return result;
}


