#ifndef ETHERNET_H
#define ETHERNET_H

#include "types.h"

#define MAX_ETH_PACKET_SIZE 512

typedef u8 en_addr[6];

typedef struct {
  u16 length;
  u8 *data;
} en_raw_packet;

typedef struct {
  en_addr dest_addr;
  en_addr src_addr;
  u16 type;
  u16 length;
  u8 *data;
  u32 crc;
} en_packet;

en_packet *decode_en_packet(en_raw_packet *raw);
en_raw_packet *encode_en_packet(en_packet *pkt);

void free_en_packet(en_packet *pkt);
void free_en_raw_packet(en_raw_packet *pkt);


#endif /* ETHERNET_H */
