#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/un.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <errno.h>
#include <termios.h>
#include <poll.h>

#include "router.h"

int eth0_sock, eth1_sock;
u16 eth0_intcount, eth1_intcount;
FILE *eth0_file, *eth1_file;

static int hardware_up = 0;

void create_fifos(void) {}
void destroy_fifos(void) {}
void enable_interrupts(void) {}
void disable_interrupts(void) {}
void set_exception(u16 except_mode) {}
void clear_screen(void) {}

/****************************** handle_fifos ******************************/
void handle_fifos(void) {
    int rc, ear;
    struct timeval tv;
    fd_set rset;
    u8 buffer[64];
    ether_packet *header;
    int length;
    memblock *curblock, *base;
    char *data, *ptr;
    
    if (!hardware_up)
	return;

    tv.tv_sec = 0;
    tv.tv_usec = 0;

    FD_ZERO(&rset);
    FD_SET(eth0_sock, &rset);
    FD_SET(eth1_sock, &rset);

    rc = select(5, &rset, NULL, NULL, &tv);
    ERR(rc);
    if (rc == 0)
	return;
    
	/* Check if a new packet has arrived in eth0_fifo */
    if (FD_ISSET(eth0_sock, &rset)) { 
	ear = accept(eth0_sock, NULL, NULL);
	if (ear == -1)
	    ERR(1);
	
	rc = read(ear, buffer, 40); /* enough for ether + ip */
	ERR(rc);
	
	curblock = copy_to_new_memblock(buffer);
	if (!curblock) {
	    errno = ENOMEM;
	    ERR(1);
	}
	header = unpack_ether_header(curblock);
	length = header->length;

	length -= rc; /* subtract what's already read */
	
	data = malloc(length+40);
	if (!data) {
	    errno = ENOMEM;
	    ERR(1);
	}	    
	
	memcpy(data, buffer, 40);
	free_memblock_chain(curblock);

	ptr = data+40;
	while(length > 0) {
	    rc = read(ear, ptr, length);
	    ERR(rc);
	    length -= rc;
	    ptr += rc;
	}
	
	printf("received %d on eth0\n", header->length);
	    /* ok, read it all in, reset length to do memblockization */
	ptr = data;
	base = copy_to_new_memblock(data);
	curblock = base;
	length = header->length - 64;
	ptr += 64;
	while (length > 0) {
	    curblock->next = copy_to_new_memblock(ptr);
	    if (!curblock->next) {
		errno = ENOMEM;
		ERR(-1);
	    }
	    curblock = curblock->next;
	    ptr+=64;
	    length -= 64;
	}
	
	route_packet(ETH0, base);
	free(header);
    }

	/* Check if a new packet has arrived in eth1_fifo */
    if (FD_ISSET(eth1_sock, &rset)) { 
	ear = accept(eth1_sock, NULL, NULL);
	if (ear == -1)
	    ERR(1);
	
	rc = read(ear, buffer, 40); /* enough for ether + ip */
	ERR(rc);
	
	curblock = copy_to_new_memblock(buffer);
	if (!curblock) {
	    errno = ENOMEM;
	    ERR(1);
	}
	header = unpack_ether_header(curblock);
	length = header->length;

	length -= rc; /* subtract what's already read */
	
	data = malloc(length+40);
	if (!data) {
	    errno = ENOMEM;
	    ERR(1);
	}	    
	
	memcpy(data, buffer, 40);
	free_memblock_chain(curblock);

	ptr = data+40;
	while(length > 0) {
	    rc = read(ear, ptr, length);
	    ERR(rc);
	    length -= rc;
	    ptr += rc;
	}
	
	printf("received %d on eth1\n", header->length);
	    /* ok, read it all in, reset length to do memblockization */
	ptr = data;
	base = copy_to_new_memblock(data);
	curblock = base;
	length = header->length - 64;
	ptr += 64;
	while (length > 0) {
	    curblock->next = copy_to_new_memblock(ptr);
	    if (!curblock->next) {
		errno = ENOMEM;
		ERR(-1);
	    }
	    curblock = curblock->next;
	    ptr+=64;
	    length -= 64;
	}
	
	route_packet(ETH1, base);
	free(header);
    }

}

/****************************** route_packet ********************************/
void route_packet(u8 interface, memblock *chain) {
    ether_packet *epacket;
    arp_packet *apacket;
    ipv4_packet *ippacket;

    epacket = unpack_ether_header(chain);
    
    apacket = decode_arp_packet(epacket);
    if (apacket) { /* if this actually was an arp packet */
	handle_arp_packet(interface, epacket);
	free(apacket);
	free(epacket);
	free_memblock_chain(chain);
	return;
    }
    
    ippacket = unpack_ipv4_packet(epacket);
    if (ippacket) { /* if this actually was an ipv4 packet */
	handle_ipv4_packet(epacket);
	free(ippacket);
	free(epacket);
	free_memblock_chain(chain);
	return;
    }
    printf("Not IP or ARP packet!\n");
}

/****************************** config_hardware ******************************/
void config_hardware(u8 dir) {
    int rc, len;
    struct sockaddr_un eth0_serv, eth1_serv;
    
    if (dir == UP) {
	    /* create socket 1 */
	eth0_sock = socket(AF_UNIX, SOCK_STREAM, 0);
	ERR(eth0_sock);

	unlink(ETH0_PATHNAME);

	memset(&eth0_serv, 0, sizeof(eth0_serv));
	eth0_serv.sun_family = AF_UNIX;
	strcpy(eth0_serv.sun_path, ETH0_PATHNAME);
#if defined(__NetBSD__)
	len = strlen(eth0_serv.sun_path) + sizeof(eth0_serv.sun_family) + 1;
	eth0_serv.sun_len = len;
#elif defined(__sun__)
	len =  strlen(eth0_serv.sun_path) + sizeof(eth0_serv.sun_family) + 1;
#endif
	rc = bind(eth0_sock, 
		  (struct sockaddr *)&eth0_serv, 
		  len);
	ERR(rc);

	rc = listen(eth0_sock, 0);
	ERR(rc);

	    /* create socket 2 */
	eth1_sock = socket(AF_UNIX, SOCK_STREAM, 0);
	if (eth1_sock == -1)
	    ERR(1);

	unlink(ETH1_PATHNAME);

	memset(&eth1_serv, 0, sizeof(eth1_serv));
	eth1_serv.sun_family = AF_UNIX;
	strcpy(eth1_serv.sun_path, ETH1_PATHNAME);
#if defined(__NetBSD__)
	len = strlen(eth1_serv.sun_path) + sizeof(eth1_serv.sun_family) + 1;
	eth1_serv.sun_len = len;
#elif defined(__sun__)
	len =  strlen(eth1_serv.sun_path) + sizeof(eth1_serv.sun_family) + 1;
#endif
	rc = bind(eth1_sock, 
		  (struct sockaddr *)&eth1_serv, 
		  len);
	ERR(rc);

	rc = listen(eth1_sock, 3);
	ERR(rc);

	eth0_file = fopen("eth0_output", "w");
	if (!eth0_file)
	    ERR(-1);
	eth1_file = fopen("eth1_output", "w");
	if (!eth1_file)
	    ERR(-1);

	hardware_up = 1;
    } else if (dir == DOWN) {
	unlink(ETH0_PATHNAME);
	unlink(ETH1_PATHNAME);
    }
}


/****************************** send_packet ******************************/
void send_packet(u8 interface, ether_packet *packet) {
    int rc, remain;
    memblock *curblock = packet->data;
    u16 length = packet->length;
    char *data, *ptr;
/*  int fd */
    FILE *fd;

    printf("Sending a packet of length = %d out interface %d\n", 
	   length, interface);
/*    fd = (interface == ETH0)?eth0_sock:eth1_sock; */
    fd = (interface == ETH0)?eth0_file:eth1_file;

    data = malloc(length);
    if (!data) {
	errno = ENOMEM;
	ERR(-1);
    }

    ptr = data;
    while (length > 0) {
	remain = (length>64)?64:length;
	memcpy(ptr, curblock->data, remain);
	length -= remain;
	ptr += remain;
	curblock = curblock->next;
    }
    
    length = packet->length;
    ptr = data;
    while(length > 0) {
/*	rc = write(fd, ptr, length); */
	rc = fwrite(ptr, 1, length, fd);
	ERR(rc);
	length -= rc;
	ptr += rc;
    }

    fflush(fd);
    free(data);
}

/********************************* set_term *******************************/
void set_term(u16 *except_ptr) {
    int rc;
    struct termios buf;
    
    rc = tcgetattr(STDIN_FILENO, &buf);
    ERR(rc);
    buf.c_lflag &= ~(ICANON);
    
    buf.c_cc[VMIN] = 0;
    buf.c_cc[VTIME] = 0;
    
    rc = tcsetattr(STDIN_FILENO, TCSAFLUSH, &buf);
    ERR(rc);
}

/********************************* kbhit *******************************/
int kbhit(){  
    int rc;
    char c;
    
    rc = read(STDIN_FILENO, &c, sizeof(char));
    if (!rc)
	return 0;
    ERR(rc);
    ungetc(c, stdin); /* replace character in stream */
    return 1; 
}  

/********************************* err_handler *******************************/
void err_handler(u16 line, char *fname, u16 status) {
    perror(NULL);
    fprintf(stderr, "Error %d occurred at %s:%d\n", errno, fname, line);
    exit(status);
}
