#ifndef _NORMAL_RESPONSE_H
#define _NORMAL_RESPONSE_H

#include "ps5/http_response.h"

class normal_response : public http_response {
    // An "normal_response" represents an HTTP/1.0 response that is
    // a page of text, i.e. of type "text/html" or "text/plain".
public:
    normal_response(bool html);
	// create a new "normal_response" that is an HTML response if
	// "html" is true, else it is a plain text response.
    virtual void body(ostream &o);
	// inherited: return a short default message string that depends
	//            on whether this is an HTML or plain text response.
    virtual string content_type();
        // effects: Return ``"text/html"'' or ``"text/plain"'' appropriately.
protected:
    bool html_response;
};

#endif /* _NORMAL_RESPONSE_H */



