// $Id: test_board.C,v 1.4 1995/11/26 04:19:49 jered Exp $
#include <game.h>
#include <move.h>
#include <ps5/error_response.h>
#include "test_board.h"

class test_move: public move {
public:
  test_move(int piecenum) {
  // Checks: 0 < piecenum <= 10
  // Effects: Creates a move corresponding to taking piece number piecenum.
    check((0 < piecenum) && (piecenum <= 10), "test_move: Invalid move!");
    piecetaken=piecenum; }        // Fill in piecetaken

  test_move(const test_move &m) {
    piecetaken=m.piecetaken; }    // Copy piecetaken

  virtual ~test_move(){};

  virtual void display(extensions *ext, ostream& body) {
  // Effects: Sends "takes <piecetaken>" to the ostream.
    body << "takes " << piecetaken; }

  virtual bool operator==(move &m) {
  // Effects: Returns true if the moves are identical, false otherwise.
    test_move* ptr = (test_move*)m.force(test_move::typeinfo);
    if (ptr) return (piecetaken == ptr->piecetaken); 
    else return false; }           // They're not even the same type...

  virtual move* copy() {
  // Effects: Returns a heap copy of this move.
    return new test_move(*this); }

  virtual void* force(typeinfo_t &type) {
    if (type == typeinfo) return this;
    else return 0; }

  test_move& operator=(const test_move& m) {
  // Modifies: this
  // Effects: this becomes m
    piecetaken = m.piecetaken;    // Copy piecetaken
    return *this; }

  int get_piece_taken() {
    return piecetaken; }          // Return piece taken

  static typeinfo_t typeinfo;

private:
  test_move();                    // Disable default constructor
  int piecetaken;                 // Piece taken by this move
};

typeinfo_t test_move::typeinfo = new_typeinfo();

class test_move_gen : public generator <move *> {
public:
  test_move_gen(int curr_highest) {
  // Effects: constructs a generator that returns the valid moves
  // given curr_highest as the current highest piece taken.
    last_taken = curr_highest; }

  bool get(move *&m) {
  // Modifies: this
  // Effects:  If more moves remain, returns true and sets m to be a pointer
  // to the next move, else returns false.
    if (last_taken >= 10) return false;    // That's all the moves left
    m=new test_move(last_taken);
    return true; }

private:
    int last_taken;
};


test_board::test_board(){
  highest_taken = 0;              // Reset the game
  won_player = NULL;              // Nobody has won
}

bool test_board::is_legal_move(move &m, const player *p) const {
  test_move* ptr = (test_move*)m.force(test_move::typeinfo);
  if (!ptr) return false;        // I can't use this move here
  if (ptr->get_piece_taken() > highest_taken) 
    return true;                 // A valid move!
  else return false;             // Nope, can't do that.
}

game::move_result test_board::apply(move &m, player *p) {
  test_move* ptr = (test_move*)m.force(test_move::typeinfo);
  if (!ptr) return game::move_invalid; // I can't use this move here
  if (!is_legal_move(m, p))
    return game::move_invalid;         // That move was invalid
  highest_taken = ptr->get_piece_taken();
  if (highest_taken == 10)
    won_player = p;                    // Player p has won!
  return game::ok;                     // Move applied.
}

bool test_board::unapply(move &m, const player *p) {
// Unapplication of moves is not supported in this game.
  return false; }

player* test_board::winner() {
  return won_player;}

http_response* test_board::get(string request, extensions *extras){
  return new error_response(http_response::OK,
			    "test_board::get unimplemented."); }

void test_board::display(extensions *ext, ostream& body) const {
  body << "<H2>The current game board:</H2>" << endl;
  body << "The highest piece taken is <B>" << highest_taken;
  body << "</B><P>" << endl;
}

generator<move*>* test_board::valid_moves() const{
  return new test_move_gen(highest_taken); }

board::value test_board::eval_move_delta(move &m, const player *p) const {
  test_move* ptr = (test_move*)m.force(test_move::typeinfo);
  if (!ptr) return 0;          // I can't use this move here
  if (!is_legal_move(m, p))
    return 0;                  // That move was invalid
  switch(ptr->get_piece_taken()) {
  case 10:
    return 1;                  // Gee, that's a good move, isn't it?

  case 9:
    return -1;                 // Hmm, do I want to force my opponent
                               // to win? Really?
  default:
    return 0;                  // Indifferent.
  }
}

board::value test_board::evaluate(const player *p) const {
  if (highest_taken == 9)
    return 1;                  // Player has no choice but to win.
  return 0;
}

void* test_board::force(typeinfo_t &t){
  if (t == typeinfo) return this;
  else return 0;
}

typeinfo_t test_board::typeinfo = new_typeinfo();
