/* rmxtypes.h - iRMX (reg. TM) System Call Data Types
 * $Version: 1.9 $
 * Copyright (C) 1993 Intel Corporation, ALL RIGHTS RESERVED
 */

#ifndef _RMXTYPES 
#define _RMXTYPES

#include <yvals.h>

#ifndef _MAX_STRING
#   define  _MAX_STRING 255
#endif

typedef struct {
     unsigned char     length;
     unsigned char     text[_MAX_STRING];    /* adjust # of bytes in string */
} RMX_STRING;

/*
 * macro definitions for PL/M Data Types
 */

#define  BOOLEAN    unsigned char
#define  BYTE       unsigned char


#ifdef _LONG64_
#   define NATIVE_WORD unsigned int
#else
#   ifdef __INT16__
#       define  NATIVE_WORD unsigned short
#   else    /* __INT32__ */
#       define  NATIVE_WORD unsigned long32 
#   endif
#endif

#define  WORD       unsigned short
#define  WORD_16    unsigned short
#define  WORD_32    unsigned long32
#define  DWORD      unsigned long32 
#define  NULLSEL    (selector)0
#define  STRING     char
#define  TOKEN      selector 
#define  SELECTOR   selector


/*
 * macro definitions for Kernel Data Types
 */

typedef unsigned char       UINT_8;
typedef unsigned short      UINT_16;

#ifdef _LONG64_
    typedef unsigned long   UINT_64;
    typedef unsigned long32 UINT_32;
#else
    typedef unsigned long32 UINT_32;
#endif

#define  MAX_UINT_8         0xFF
#define  MAX_UINT_16        0xFFFF

#ifdef __INT16__
#   define  MAX_UINT_32     0xFFFFFFFFL
#else
#   define  MAX_UINT_32     0xFFFFFFFF
#endif

#ifdef _LONG64_
#   define  MAX_UINT_64     0xFFFFFFFFFFFFFFFF
#endif

#endif /* _RMXTYPES */
