/* time.h standard header
 * $Version: 1.14 $
 * Copyright (c) 1988-93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _TIME
#define _TIME

#include <yvals.h>
#include <_align.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * [1]-STANDARD C DEFINITIONS
 */
#if (_model_rmx) || (_model_blue) || (_model_posix) || (_model_green)

/*
 * macro definitions
 */

#define CLOCKS_PER_SEC  _CPS

/*
 * non-standard macro definitions
 */

#define CLK_TCK         _TIC
#define _DAYLIGHT_PTR   1
#define _TIMEZONE_PTR   2
#define _TZNAME_PTR     3
#define _ALTZONE_PTR    4

/*
 * type definitions
 */

#ifndef _SIZET
#define _SIZET
typedef _Sizet size_t;
#endif
#ifndef _TIMET
#define _TIMET
typedef _Timet time_t;
#endif
#ifndef _CLOCKT
#define _CLOCKT
typedef _Clockt clock_t;
#endif

/*
 * structure definitions
 */

struct tm {
    _aligndef(int, tm_sec)       /* seconds     (0-59) */
    _aligndef(int, tm_min)       /* minutes     (0-59) */
    _aligndef(int, tm_hour)      /* hours       (0-23) */
    _aligndef(int, tm_mday)      /* days        (1-31) */
    _aligndef(int, tm_mon)       /* months      (0-11) */
    _aligndef(int, tm_year)      /* year        (minus 1900) */
    _aligndef(int, tm_wday)      /* day of week (sun = 0) */
    _aligndef(int, tm_yday)      /* day of year (0-365)     */
    _aligndef(int, tm_isdst)     /* non-zero if DST    */
};

/*
 * function prototypes
 */

char      * _Pascal asctime(const struct tm *);
clock_t     _Pascal clock(void);
char      * _Pascal ctime(const time_t *);
double      _Pascal difftime(time_t, time_t);
struct tm * _Pascal gmtime(const time_t *);
struct tm * _Pascal localtime(const time_t *);
time_t      _Pascal mktime(struct tm *);
size_t      _Pascal strftime(char *, size_t, const char *, const struct tm *);
time_t      _Pascal time(time_t *);
void        _Pascal tzset(void);

#ifdef __WATCOMC__
#pragma aux (pascal) difftime;
#endif

#endif /* rmx, blue, posix and green */

/*
 * [2]-COMMON DEFINITIONS THAT ARE NOT STANDARD C DEFINITIONS
 */
#if (_model_blue) || (_model_posix) || (_model_green)
#endif /* blue, posix and green */

/*
 * [3]-COMMON NETWORK DEFINITIONS (same as _UNIX_SOURCE)
 */
#if (_model_blue) || (_model_green)
#endif /* blue and green */

/*
 * [4]-COMMON NON-POSIX DEFINITIONS
 */
#if (_model_rmx) || (_model_blue)

#include <reent.h>

/*
 * non-standard macro definitions
 */

#define daylight        (* (int   *) _tzset_ptrs(_DAYLIGHT_PTR))
#define timezone        (* (long32 *) _tzset_ptrs(_TIMEZONE_PTR))
#define tzname     	    (  (char **) _tzset_ptrs(_TZNAME_PTR))

#endif /* rmx and blue */

/*
 * [5]-POSIX SPECIFIC DEFINITIONS (same as _POSIX_SOURCE)
 */
#if (_model_posix) || (_model_green)

extern int      daylight;
extern long32   timezone;
extern char   * tzname[];
extern long32   altzone;

#endif /* posix and green */

/*
 * [6]-RMX SPECIFIC DEFINITIONS
 */
#if (_model_rmx)
#endif /* rmx */

/*
 * [7]-NON-POSIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_blue)
#endif /* blue */

/*
 * [8]-UNIX/UNIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_green)
#endif /* green */

#ifdef __cplusplus
}
#endif

#include <_restore.h>

#endif /* _TIME */
