/* yvals.h - values header
 * $Version: 1.28 $
 * Copyright (c) 1993 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _YVALS
#define _YVALS

#ifndef _MODEL
#   define _MODEL

#   if !defined(_POSIX_SOURCE) && !defined(_UNIX_SOURCE)
#       define  _model_rmx      1
#       define  _model_blue     0
#       define  _model_posix    0
#       define  _model_green    0
#   endif

#   if !defined(_POSIX_SOURCE) && defined(_UNIX_SOURCE)
#       define  _model_rmx      0
#       define  _model_blue     1
#       define  _model_posix    0
#       define  _model_green    0
#   endif

#   if defined(_POSIX_SOURCE) && !defined(_UNIX_SOURCE)
#       define  _model_rmx      0
#       define  _model_blue     0
#       define  _model_posix    1
#       define  _model_green    0
#   endif

#   if defined(_POSIX_SOURCE) && defined(_UNIX_SOURCE)
#       define  _model_rmx      0
#       define  _model_blue     0
#       define  _model_posix    0
#       define  _model_green    1
#   endif
#endif /* _MODEL */



/*
 * compiler specific defintions
 */

/*
 * Definitions for the Intel compilers (IC286, IC386)
 */
#if defined(_ARCHITECTURE_)

#   if _ARCHITECTURE_ < 386
#       define  __IC286__       /* IC286 compiler */
#   else
#       define  __IC386__       /* IC286 compiler */
#   endif

#	if _FAR_CODE_
#		define  __LARGE__
#	else
#		define  __COMPACT__
#	endif

#   pragma  fixedparams
#   define  _Cdecl
#   define  _Fparam
#   define  _Pascal
#   define  _ROM
#   define  __export
#   define  __loadds
#   define  _DBL_MAX            1.7976931348623157e+308
#   define  MK_FP               buildptr
#   define  geninterrupt        causeinterrupt

    /* macros to break 'far' pointers into segment and offset components */

#   define  FP_OFF(__p)         ((unsigned short)(__p))
#   define  FP_SEG(__p)         ((selector)(__p))

#   define  _FP_SEG             FP_SEG
#   define  _FP_OFF             FP_OFF


    /* IC286 specific definitions */
    
#   if defined(__IC286__)

#       include <i286.h>
#       include <_align.h>

#       define  __INT16__               1
#       define  _aligndef(type, name)   type   name; int    _##name;
#       define  _ptrdef(type, name)     type * name; long   _##name;
#       define  long32                  long 

        typedef struct {
            unsigned long32 offset;
            unsigned long32 descriptor;
        } voidptr32;


    /* IC386 specific definitions */
    
#   elif defined(__IC386__)

#       include <i386.h>

#       define  __INT32__               1
#       define  _aligndef(type, name)   type   name;
#       define  _ptrdef(type, name)     type * name;

#       if _LONG64_
#           define  long32      int
#       else 
#           define  long32      long
#       endif

#       define  voidptr32       void far *

#   endif   /* if defined(__IC386__) */


/*
 * Definitions for the Borland compiler
 */

#elif defined(__BORLANDC__)

#   if __MEDIUM__ || __HUGE__ || __SMALL__ || __TINY__ 
#       error invalid memory model
#   endif

#   if __WIN32__
#       define  __INT32__       1   /* 32-bit Borland */
#   else
#       define  __INT16__       1   /* 16-bit Borland */
#   endif

#   define  _Cdecl              __cdecl
#   define  _Fparam             __pascal
#   define  _Pascal             __pascal
#   define  long32              long 
#   define  selector            unsigned short 
#   define  _DBL_MAX            1.7976931348623157e+308

    /* Intel compatible builtins */

#   define  causeinterrupt(level)   asm {int level} 
#   define  disable()               asm {cli} 
#   define  enable()                asm {sti} 

#   define outbyte(port,value)      \
        asm {                       \
            mov dx, port;           \
            mov al, value;          \
            out dx, al;             \
        }

#   define outhword(port,value)     \
        asm {                       \
            mov dx, port;           \
            mov ax, value;          \
            out dx, ax;             \
        }

#   define outword(port,value)      \
        asm {                       \
            mov dx, port;           \
            mov ax, value;          \
            out dx, ax;             \
        }

    unsigned char _Fparam   inbyte 
    (
        unsigned short          port
    );

    unsigned short _Fparam  inhword 
    (
        unsigned short          port
    );

    unsigned int _Fparam    inword 
    (
        unsigned short          port
    );

    void _Fparam            blockinbyte
    (
        unsigned short          port, 
        unsigned char *         dest_ptr, 
        unsigned int            count
    );

    void _Fparam            blockinhword
    (
        unsigned short          port, 
        unsigned short *        dest_ptr, 
        unsigned int            count
    );

    void _Fparam            blockinword
    (
        unsigned short          port, 
        unsigned int *          dest_ptr, 
        unsigned int            count
    );

    void _Fparam            blockoutbyte
    (
        unsigned short          port, 
        unsigned char *         dest_ptr, 
        unsigned int            count
    );

    void _Fparam            blockouthword
    (
        unsigned short          port,   
        unsigned short *        dest_ptr, 
        unsigned int            count
    );

    void _Fparam            blockoutword
    (
        unsigned short          port,   
        unsigned int *          dest_ptr, 
        unsigned int            count
    );

    unsigned char _Fparam   byte_ror 
    (
        unsigned char           _inbyte, 
        unsigned int            count
    );

    unsigned char _Fparam   byte_rol 
    (
        unsigned char           _inbyte, 
        unsigned int            count
    );

    unsigned short _Fparam  hword_ror 
    (
        unsigned short          _inhword, 
        unsigned int            count
    );


    unsigned short _Fparam  hword_rol 
    (
        unsigned short          _inhword, 
        unsigned int            count
    );


    unsigned int _Fparam    word_ror 
    (
        unsigned int            _inword, 
        unsigned int            count
    );


    unsigned int _Fparam    word_rol 
    (
        unsigned int            _inword, 
        unsigned int            count
    );


    /* 32-bit Borland specific definitions */
    
#   ifdef __INT32__
#       define  far
#       define  near

#       define  _aligndef(type, name)   type   name;
#       define  _ptrdef(type, name)     type * name; short _##name;

        unsigned short _Pascal FP_SEG( void * fp );

#       define  FP_OFF( fp )    ( (unsigned )( fp ))

#       define  _FP_OFF         FP_OFF
#       define  _FP_SEG         FP_SEG


    /* 16-bit Borland specific definitions */
    
#   else        /* __INT16__ */
#       define  far             __far
#       define  near            __near

#       define  _aligndef(type, name)   type   name; int    _##name;
#       define  _ptrdef(type, name)     type * name; long   _##name;

#       define  MK_FP( seg,ofs )    ((void _seg *)(seg)+(void near *)(ofs))
#       define  FP_SEG( fp )        ((unsigned)(void _seg *)(void far *)( fp ))
#       define  FP_OFF( fp )        ((unsigned)(fp))

#       define buildptr(_sel, _off) MK_FP ((unsigned short) _sel, \
                                    (unsigned short) _off)

#       define  _FP_OFF         FP_OFF
#       define  _FP_SEG         FP_SEG

#       include <_align.h>

        typedef struct {
            unsigned long32 offset;
            unsigned long32 descriptor;
        } voidptr32;

#   endif       /* __INT16__ */


/*
 * Definitions for the Watcom compiler
 */

#elif defined(__WATCOMC__)

#   if defined __SMALL__ || defined __MEDIUM__ || defined __LARGE__
#       error invalid memory model
#   endif

    /* Pragmas for defining function attributes */

#   pragma off(check_stack)
#   pragma aux cdecl "_*" parm caller []\
        value struct float struct routine [eax] modify [eax ebx ecx edx];
#   pragma aux pascal "^" parm routine reverse []\
        value struct float struct caller [] modify [eax ebx ecx edx];
#   pragma aux syscall "*" parm routine reverse []\
        value struct float struct caller [] modify [eax ebx ecx edx edi esi];

#   define  __INT32__           1
#   define  STDIN_FILENO        0
#   define  STDOUT_FILENO       1
#   define  STDERR_FILENO       2

#   define  _aligndef(type, name)   type   name;
#   define  _ptrdef(type, name)     type * name;

#   define  _Cdecl              __cdecl
#   define  _Fparam             __syscall
#   define  _Pascal             __pascal
#   define  _ROM          
#   define  _complex            complex 
#   define  long32              long
#   define  selector            __segment

    typedef void far *          voidptr32;

#   define  _DBL_MAX            1.79769313486231500e+308

#   define MK_FP(__s,__o)   (((unsigned short)(__s)):>((void __near *)(__o)))

    /* macros to break 'far' pointers into segment and offset components */
#   define  FP_OFF(__p)     ((unsigned int)(__p))

    unsigned short FP_SEG( void __far * );
#   pragma aux   FP_SEG = parm caller [eax dx] value [dx];

#   define _FP_SEG              FP_SEG
#   define _FP_OFF              FP_OFF

    /* Intel compatible builtins */

#   define buildptr             MK_FP

    unsigned char inbyte (unsigned short);
#   pragma aux inbyte =             \
            "in     al, dx"         \
            value [al]              \
            parm [edx];               

    unsigned short inhword (unsigned short);
#   pragma aux inhword =            \
            "in     ax, dx"         \
            value [ax]              \
            parm [edx];               

    unsigned int inword (unsigned short);
#   pragma aux inword =             \
            "in     eax, dx"        \
            value [eax]             \
            parm [edx];               

    void outbyte (unsigned short, unsigned char);
#   pragma aux outbyte =            \
            "out    dx, al"         \
            parm [edx] [al];

    void outhword (unsigned short, unsigned short);
#   pragma aux outhword =           \
            "out    dx, ax"         \
            parm [edx] [ax];

    void outword (unsigned short, unsigned int);
#   pragma aux outword =            \
            "out    dx, eax"        \
            parm [edx] [eax];

    void blockinbyte (unsigned short, unsigned char *, unsigned int);
#   pragma aux blockinbyte =        \
            "cld"                   \
            "jcxz    ib_label"      \
            "rep insb"              \
       "ib_label:"                  \
            parm [edx] [es edi] [ecx];

    void blockinhword (unsigned short, unsigned short *, unsigned int);
#   pragma aux blockinhword =       \
            "cld"                   \
            "jcxz    iw_label"      \
            "rep insw"              \
        "iw_label:"                 \
            parm [edx] [es edi] [ecx];

    void blockinword (unsigned short, unsigned int *, unsigned int);
#   pragma aux blockinword =        \
            "cld"                   \
            "jcxz    iw_label"      \
            "rep insd"              \
        "iw_label:"                 \
            parm [edx] [es edi] [ecx];

    void blockoutbyte (unsigned short, unsigned char const *, unsigned int);
#   pragma aux blockoutbyte =       \
            "cld"                   \
            "jcxz    ob_label"      \
            "rep outsb"             \
        "ob_label:"                 \
            parm [edx] [ds esi] [ecx];

    void blockouthword (unsigned short, unsigned short const *, unsigned int);
#   pragma aux blockouthword =      \
            "cld"                   \
            "jcxz    ow_label"      \
            "rep outsw"             \
        "ow_label:"                 \
            parm [edx] [ds esi] [ecx];

    void blockoutword (unsigned short, unsigned int const *, unsigned int);
#   pragma aux blockoutword =       \
            "cld"                   \
            "jcxz    ow_label"      \
            "rep outsd"             \
        "ow_label:"                 \
            parm [edx] [ds esi] [ecx];

    unsigned char byte_rol (unsigned char, unsigned int);
#   pragma aux byte_rol =           \
            "rol    al, cl"         \
            value [al]              \
            parm [al] [ecx];

    unsigned char byte_ror (unsigned char, unsigned int);
#   pragma aux byte_ror =           \
            "ror    al, cl"         \
            value [al]              \
            parm [al] [ecx];

    unsigned short hword_rol (unsigned short, unsigned int);
#   pragma aux hword_rol =          \
            "rol    ax, cl"         \
            value [ax]              \
            parm [ax] [ecx];

    unsigned short hword_ror (unsigned short, unsigned int);
#   pragma aux hword_ror =          \
            "ror    ax,cl"          \
            value [ax]              \
            parm [ax] [ecx];

    unsigned int word_rol (unsigned int, unsigned int);
#   pragma aux word_rol =           \
            "rol    eax, cl"        \
            value [eax]             \
            parm [eax] [ecx];

    unsigned int word_ror (unsigned int, unsigned int);
#   pragma aux word_ror =           \
            "ror    eax,cl"         \
            value [eax]             \
            parm [eax] [ecx];

    void causeinterrupt(unsigned char);
#   pragma aux causeinterrupt =     \
            "int 3"                 \
            parm [ax];

    void disable(void);
#   pragma aux disable = "cli";    

    void enable(void);
#   pragma aux enable = "sti";    


/*
 * Definitions for the Microsoft compiler
 */

#elif defined(_MSC_VER)

#   if M_I86TM || M_I86SM || M_I86MM || M_I86_HM
#       error invalid memory model
#   endif

#	ifdef M_I86CM
#		define  __COMPACT__
#	elif defined(M_I86LM)
#		define  __LARGE__
#	endif


#   pragma warning(disable:4103)
#   pragma inline_depth( 10 )
#   pragma check_stack(off)

#   ifdef M_I86_LM
#       define _FAR_CODE_       1
#   endif

#   define  _aligndef(type, name)   type   name; int    _##name;
#   define  _ptrdef(type, name)     type * name; long   _##name;

#   define  __INT16__           1
#   define  _Cdecl              __cdecl
#   define  _Fparam             __pascal
#   define  far                 __far
#   define  huge                __huge
#   define  long32              long 
#   define  near                __near
#   define  _Pascal             __pascal
#   define  _ROM                __based (__segname ("_CODE"))
#   define  selector            __segment
#   define  _DBL_MAX            1.7976931348623158e+308     /* max value */
#   define  _SH_COMPAT          SH_COMPAT
#   define  _SH_DENYRW          SH_DENYRW
#   define  _SH_DENYWR          SH_DENYWR
#   define  _SH_DENYRD          SH_DENYRD
#   define  _SH_DENYNO          SH_DENYNO
#   define  _DOS_MODE           0                           /* DOS */
#   define  _OS2_MODE           1                           /* OS/2 */
#   define  _WIN_MODE           2                           /* Windows */
#   define  __max(a,b)          max(a,b)
#   define __min(a,b)           min(a,b)

    typedef struct {
        unsigned long32 offset;
        unsigned long32 descriptor;
    } voidptr32;

#   ifdef CPPLIB
#       ifdef __cplusplus
            extern "C" {
#       endif

        int   _Cdecl _write(int, const char *, unsigned int);
        int   _Cdecl _read(int, char *, unsigned int);
        int   _Cdecl _close(int);
        int   _Cdecl _lseek(int, int, int);
        int   _Cdecl _setmode(int, int);
        int   _Cdecl _sopen(const char *, int, int, ...);
        extern unsigned char __near _Cdecl _osmode;

        #ifdef __cplusplus
            }
        #endif
    #endif

    __inline void far * MK_FP(unsigned short Pseg, unsigned short Poff)
    {   
        return (void far *) (((long)Pseg << 16) | Poff);
    }

    /* macros to break 'far' pointers into segment and offset components */
#   define  FP_OFF(__p)         ((unsigned)(__p))
#   define  FP_SEG(__p)         ((selector)(__p))

#   define _FP_SEG              FP_SEG
#   define _FP_OFF              FP_OFF

    /* Intel compatible builtins */

#   define  buildptr(_sel, _off)    MK_FP ((unsigned short) _sel, \
                                    (unsigned short) _off)

#   define  causeinterrupt(level)   __asm {__asm int level} 
#   define  disable()               __asm {__asm cli} 
#   define  enable()                __asm {__asm sti} 

#   define outbyte(port,value)      \
        __asm {                     \
            __asm mov   dx, port    \
            __asm mov   al, value   \
            __asm out   dx, al      \
        }

#   define outword(port,value)      \
        __asm {                     \
            __asm mov   dx, port    \
            __asm mov   ax, value   \
            __asm out   dx, ax      \
        }
        
#   define outhword(port,value)     \
        __asm {                     \
            __asm mov   dx, port    \
            __asm mov   ax, value   \
            __asm out   dx, ax      \
        }
        
    __inline unsigned char _Fparam inbyte(unsigned port) {
       unsigned char   _inbyte;
      __asm {     
            __asm mov   dx, port
            __asm in    al, dx
            __asm mov   _inbyte, al
        }
        return (_inbyte);
    }


    __inline unsigned _Fparam inword(unsigned port) {
        short       _inword;
        __asm {     
            __asm mov   dx, port
            __asm in    ax, dx
            __asm mov   _inword, ax
        }
        return (_inword);
    }

    __inline unsigned _Fparam inhword(unsigned port) {
        short       _inhword;
        __asm {     
            __asm mov   dx, port
            __asm in    ax, dx
            __asm mov   _inhword, ax
        }
        return (_inhword);
    }

    __inline void _Fparam blockinbyte(unsigned short port,
                unsigned char *dest_ptr, unsigned int count) {
        __asm {     
            __asm mov   cx, count       
            __asm jcxz  __zero_count    
            __asm mov   dx, port            
            __asm les   di, dest_ptr    
            __asm cld                       
            __asm rep   insb                
            __asm __zero_count:
        }
    }


    __inline void _Fparam blockinhword(unsigned short port,
                unsigned int *dest_ptr, unsigned int count) {
        __asm {     
            __asm mov   cx, count       
            __asm jcxz  __zero_count    
            __asm mov   dx, port            
            __asm les   di, dest_ptr    
            __asm cld                       
            __asm rep   insw                
            __asm __zero_count:
        }
    }

    __inline void _Fparam blockinword(unsigned short port,
                unsigned int *dest_ptr, unsigned int count) {
        __asm {     
            __asm mov   cx, count       
            __asm jcxz  __zero_count    
            __asm mov   dx, port            
            __asm les   di, dest_ptr    
            __asm cld                       
            __asm rep   insw                
            __asm __zero_count:
        }
    }

    __inline void _Fparam blockoutbyte(unsigned short port,
                unsigned char *dest_ptr, unsigned int count) {
        __asm {     
            __asm mov   cx, count       
            __asm jcxz  __zero_count    
            __asm mov   dx, port            
            __asm push  ds
            __asm lds   si, dest_ptr    
            __asm cld                       
            __asm rep   outsb               
            __asm pop   ds
            __asm __zero_count:
        }
    }


    __inline void _Fparam blockouthword(unsigned short port,
                unsigned int *dest_ptr, unsigned int count) {
        __asm {     
            __asm mov   cx, count       
            __asm jcxz  __zero_count    
            __asm mov   dx, port            
            __asm push  ds
            __asm lds   si, dest_ptr    
            __asm cld                       
            __asm rep   outsw               
            __asm pop   ds
            __asm __zero_count:
        }
    }

    __inline void _Fparam blockoutword(unsigned short port,
                unsigned int *dest_ptr, unsigned int count) {
        __asm {     
            __asm mov   cx, count       
            __asm jcxz  __zero_count    
            __asm mov   dx, port            
            __asm push  ds
            __asm lds   si, dest_ptr    
            __asm cld                       
            __asm rep   outsw               
            __asm pop   ds
            __asm __zero_count:
        }
    }

    __inline unsigned char _Fparam byte_ror 
            (unsigned char _inbyte, unsigned int count) {
        unsigned char       _rotbyte;
        __asm {     
            __asm mov   al, _inbyte
            __asm mov   cx, count
            __asm ror   al, cl
            __asm mov   _rotbyte, al
        }
        return (_rotbyte);
    }

    __inline unsigned char _Fparam byte_rol 
            (unsigned char _inbyte, unsigned int count) {
        unsigned char       _rotbyte;
        __asm {     
            __asm mov   al, _inbyte
            __asm mov   cx, count
            __asm rol   al, cl
            __asm mov   _rotbyte, al
        }
        return (_rotbyte);
    }

    __inline unsigned short _Fparam hword_ror 
            (unsigned short _inhword, unsigned int count) {
        unsigned short        _rothword;
        __asm {     
            __asm mov   ax, _inhword
            __asm mov   cx, count
            __asm ror   ax, cl
            __asm mov   _rothword, ax
        }
        return (_rothword);
    }

    __inline unsigned int _Fparam word_ror 
            (unsigned int _inword, unsigned int count) {
        unsigned int        _rotword;
        __asm {     
            __asm mov   ax, _inword
            __asm mov   cx, count
            __asm ror   ax, cl
            __asm mov   _rotword, ax
        }
        return (_rotword);
    }

    __inline unsigned short _Fparam hword_rol 
            (unsigned short _inhword, unsigned int count) {
        unsigned short        _rothword;
        __asm {     
            __asm mov   ax, _inhword
            __asm mov   cx, count
            __asm rol   ax, cl
            __asm mov   _rothword, ax
        }
        return (_rothword);
    }

    __inline unsigned int _Fparam word_rol 
            (unsigned int _inword, unsigned int count) {
        unsigned int        _rotword;
        __asm {     
            __asm mov   ax, _inword
            __asm mov   cx, count
            __asm rol   ax, cl
            __asm mov   _rotword, ax
        }
        return (_rotword);
    }

#endif      /* _MSC_VER */


/*
 * Common macro definitions
 */

#define  _Caddrt            char *
#define  _Clockt            unsigned long32
#define  _Daddrt            unsigned long32
#define  _Devt              unsigned long32
#define  _Fpost             unsigned long32
#define  _Gidt              unsigned short
#define  _Inaddrt           unsigned long32
#define  _Inot              unsigned long32
#define  _Modet             unsigned long32
#define  _Nlinkt            unsigned long32
#define  _Offt              long32
#define  _Pidt              long32
#define  _Qaddrt            long32 *
#define  _Sizet             unsigned int
#define  _Wchart            unsigned short
#define  _Swblkt            long32
#define  _Timet             unsigned long32
#define  _Uidt              unsigned short
#define  _Valist            char *

#ifndef __BORLANDC__
#   define  _Ptrdifft       int
#else
#   define  _Ptrdifft       long
#endif


/*
 * errno properties
 */

#define  _EDOM               33
#define  _ERANGE             34
#define  _CTIERR             50         /* Convergent Technologies errors */
#define  _STRERR             60         /* stream errors */
#define  _SHLIBERR           83         /* shared library errors */
#define  _TCPERR             95         /* TCP/IP networking errors */
#define  _XNXERR            135         /* XENIX errors */
#define  _SUNERR            151         /* SUN NFS errors */
#define  _PYPERR            160         /* Pyramid AIO errors */
#define  _ETABOO            255
#define  _ERRMAX            255 


/*
 * math properties
 */

#define  _Hugeval           _DBL_MAX    /* DBL_MAX */


/*
 * pointer properties
 */

#define  NULL               ((void *) 0)


/*
 * setjmp properties
 */

#define  _NSETJMP           80


/*
 * signal properties
 */

#define  _SIGABRT           10
#define  _SIGMAX            32


/*
 * stdio properties
 */

#define  _FNAMAX            127
#define  _FOPMAX            20
#define  _TNAMAX            13


/*
 * stdlib properties
 */

#define  _EXFAIL            1
#define  _Mbcurmax          (sizeof(_Wchart))


/*
 * storage alignment properties
 */

#define  _AUPBND            (sizeof(int) - 1)
#define  _ADNBND            (sizeof(int) - 1) 


/*
 * time properties
 */

#define  _CPS               1000
#define  _TIC               1000

#include <_restore.h>

#endif      /* _YVALS */


/*
 * Intel compiler builtins.
 */
 
#if defined(_ARCHITECTURE_) 

#   ifdef _MATH
#       ifndef _MATH_BUILTIN
#           define _MATH_BUILTIN

            double      _Pascal fabs(double);
            double      _Pascal sqrt(double);

#           pragma _builtin_("_fabs_"==53)
            double _Pascal _fabs_(double);
#           define fabs(x) _fabs_(x)

#           pragma _builtin_("_sqrt_"==54)
            double _Pascal _sqrt_(double);
#           define sqrt(x) _sqrt_(x)

#           ifdef __IC386__

                /* 
                 * The following builtins are only valid in a 
                 * 387/486 environment
                 */

                double      _Cdecl acos(double);
                double      _Cdecl asin(double);
                double      _Cdecl atan(double);
                double      _Cdecl atan2(double, double);
                double      _Cdecl cos(double);
                double      _Cdecl sin(double);
                double      _Cdecl tan(double);
                double      _Cdecl log(double);
                double      _Cdecl log10(double);

#               pragma _builtin_("_log_"==55)
                double _Cdecl _log_(double);
#               define log(x) _log_(x)

#               pragma _builtin_("_log10_"==56)
                double _Cdecl _log10_(double);
#               define log10(x) _log10_(x)

#               pragma _builtin_("_cos_"==57)
                double _Cdecl _cos_(double);
#               define cos(x) _cos_(x)

#               pragma _builtin_("_sin_"==58)
                double _Cdecl _sin_(double);
#               define sin(x) _sin_(x)

#               pragma _builtin_("_tan_"==59)
                double _Cdecl _tan_(double);
#               define tan(x) _tan_(x)

#               pragma _builtin_("_acos_"==60)
                double _Cdecl _acos_(double);
#               define acos(x) _acos_(x)

#               pragma _builtin_("_asin_"==61)
                double _Cdecl _asin_(double);
#               define asin(x) _asin_(x)

#               pragma _builtin_("_atan2_"==62)
                double _Cdecl _atan2_(double,double);
#               define atan2(x,y) _atan2_(x,y)

#               pragma _builtin_("_atan_"==63)
                double _Cdecl _atan_(double);
#               define atan(x) _atan_(x)

#           endif   /* __INT32__ */
#       endif       /* _MATH_BUILTIN */
#   endif           /* _MATH */

#   ifdef _STDLIB
#       ifndef _STDLIB_BUILTIN
#           define _STDLIB_BUILTIN

            int               _Pascal abs(int);
            long32            _Pascal labs(long32);

#           pragma _builtin_("_abs_"==51)
            int     _Pascal _abs_(int);
#           define abs(x) _abs_(x)

#           pragma _builtin_("_labs_"==52)
            long32  _Pascal _labs_(long32);
#           define labs(x) _labs_(x)

#       endif   /* _STDLIB_BUILTIN */
#   endif       /* _STDLIB */

#   ifdef _STRING
#       ifndef _STRING_BUILTIN
#           define _STRING_BUILTIN

#           ifndef _SIZET
#               define _SIZET
                typedef _Sizet size_t;
#           endif

            void      * _Pascal memcpy(void*, const void*, size_t);
            void      * _Pascal memset(void*, int, size_t);
            char      * _Pascal strcpy(char*, const char*);

#           pragma _builtin_("_memcpy_"==64)
            void * _Pascal _memcpy_(void*, const void*, size_t);
#           define memcpy(x,y,z) _memcpy_(x,y,z)

#           pragma _builtin_("_memset_"==65)
            void * _Pascal _memset_(void*, int, size_t);
#           define memset(x,y,z) _memset_(x,y,z)

#           pragma _builtin_("_strcpy_"==71)
            char * _Pascal _strcpy_(char*, const char*);
#           define strcpy(x,y)  _strcpy_(x,y)

#       endif   /* _STRING_BUILTIN */
#   endif       /* _STRING */
#endif          /* _ARCHITECTURE_ */


