#ifndef ARPCACHE_H
#define ARPCACHE_H

#include "types.h"
#include "arp.h"
#include <time.h>

typedef struct tag_arp_cache_entry arp_cache_entry;

struct tag_arp_cache_entry {
  u32 ip_addr;
  ether_addr hw_addr;
  time_t timestamp;
  arp_cache_entry *next;
};

void arp_cache_add_entry (u32 ip_addr, ether_addr hw_addr);
void arp_cache_clear_entry (u32 ip_addr);
void arp_cache_check_timeouts(void);
arp_cache_entry *arp_cache_lookup_ip(u32 ip_addr);



#endif /* ARPCACHE_H */
