#include <stdlib.h>
#include <nucleus.h>
#include <rmx_err.h>

#include "router.h"

u16 eth0_intcount=0, eth1_intcount=0;
SELECTOR eth0_segment, eth1_segment;
SELECTOR eth0_thread, eth1_thread;

/****************************** eth0_int_receive_handler *********************/
void eth0_int_receive_handler(void) {
    WORD status;

    eth0_intcount++;
    rq_signal_interrupt((WORD)ETH0_INT_RECEIVE_LEVEL,
		       &status);
}

/******************************* eth1_int_receive_handler ********************/
void eth1_int_receive_handler(void) {
    WORD status;

    eth1_intcount++;
    rq_signal_interrupt((WORD)ETH1_INT_RECEIVE_LEVEL,
		       &status);
}

/******************************* eth0_int_receive_task *********************/
void eth0_int_receive_task(void) {
    WORD status;
    u8 newpacket;
    u16 length, totlength;
    char buffer[64];
    ether_packet *header;
    memblock *memchain, *memcur;
    
    eth0_segment = rq_create_segment(0, &status);
    ERR(status);

	/* First, install our interrupt handler */
    rq_set_interrupt((WORD)ETH0_INT_RECEIVE_LEVEL,
		     2, /* ? depth of interrupt stacking */
		     eth0_int_receive_handler,
		     eth0_segment,
		     &status);
    ERR(status);

	/* Now go into infinite loop, waiting to be notified
	   by interrupt handler */
    newpacket = 1;
    length = 64;
    while(1) {
	rq_wait_interrupt((WORD)ETH0_INT_RECEIVE_LEVEL,
			  &status);
	ERR(status);
	
	read_eth(ETH0, buffer, length);

	if (newpacket) {
	    newpacket = 0;
	    memchain = copy_to_new_memblock(buffer);
	    if (!memchain)
		ERR(E_MEM); /* no recovery attempt yet */
	    memcur = memchain;
	    header = unpack_ether_header(memchain);
	    totlength = header->length - 64; /* subtract whats already read */
	    length = (totlength>64)?64:totlength;
	} else {
	    memcur->next = copy_to_new_memblock(buffer);
	    if (!memcur->next)
		ERR(E_MEM); /* no recovery attempt yet */
	    memcur = memcur->next;
	    totlength-= length;
	}
		
	if (totlength <= 0) {
	    rq_send_data(eth0_fifo, memchain, sizeof(memblock *),
			 &status);
	    ERR(status);
	    newpacket = 1;
	    length = 64;
	    free(header);
	}
    }
	/* need to do cleanup here, or something, if we break
	   for some reason */
}

/******************************* eth1_int_recieve_task *********************/
void eth1_int_receive_task(void) {
    WORD status;
    u8 newpacket;
    u16 length, totlength;
    char buffer[64];
    ether_packet *header;
    memblock *memchain, *memcur;
    
    eth1_segment = rq_create_segment(0, &status);
    ERR(status);

	/* First, install our interrupt handler */
    rq_set_interrupt((WORD)ETH1_INT_RECEIVE_LEVEL,
		     2, /* ? depth of interrupt stacking */
		     eth1_int_receive_handler,
		     eth1_segment,
		     &status);
    ERR(status);

	/* Now go into infinite loop, waiting to be notified
	   by interrupt handler */
    newpacket = 1;
    length = 64;
    while(1) {
	rq_wait_interrupt((WORD)ETH1_INT_RECEIVE_LEVEL,
			  &status);
	ERR(status);
	
	read_eth(ETH1, buffer, length);

	if (newpacket) {
	    newpacket = 0;
	    memchain = copy_to_new_memblock(buffer);
	    if (!memchain)
		ERR(E_MEM); /* no recovery attempt yet */
	    memcur = memchain;
	    header = unpack_ether_header(memchain);
	    totlength = header->length - 64; /* subtract whats already read */
	    length = (totlength>64)?64:totlength;
	} else {
	    memcur->next = copy_to_new_memblock(buffer);
	    if (!memcur->next)
		ERR(E_MEM); /* no recovery attempt yet */
	    memcur = memcur->next;
	    totlength-= length;
	}
		
	if (totlength <= 0) {
	    rq_send_data(eth1_fifo, memchain, sizeof(memblock *),
			 &status);
	    ERR(status);
	    newpacket = 1;
	    length = 64;
	    free(header);
	}
    }
	/* need to do cleanup here, or something, if we break
	   for some reason */
}

/******************************* enable_interrupts *********************/
void enable_interrupts(void) {
    WORD status;

    eth0_thread = rq_create_task(128, /* interrupt priority */
				 eth0_int_receive_task,
				 0, /* assign own datat seg */
				 NULL, /* allocate stack for it */
				 4096, /* 4K stack */
				 0, /* shouldn't do any fp work */
				 &status);
    ERR(status);

    eth1_thread = rq_create_task(128, /* interrupt priority */
				 eth1_int_receive_task,
				 0, /* assign own datat seg */
				 NULL, /* allocate stack for it */
				 4096, /* 4K stack */
				 0, /* shouldn't do any fp work */
				 &status);
    ERR(status);
}

/******************************* disable_interrupts *********************/
void disable_interrupts(void) {
    WORD status;
    
    rq_reset_interrupt((WORD)ETH0_INT_RECEIVE_LEVEL,
		       &status);
    ERR(status);

    rq_reset_interrupt((WORD)ETH1_INT_RECEIVE_LEVEL,
		       &status);
    ERR(status);
}
