#include <stdlib.h>
#include <string.h>

void *malloc(size_t size) {
    u16 status;
    SELECTOR ret;
    
    ret = rq_create_segment(size, &status);
    ERR(status);
    
    return (void *)ret;
}

void free(void *ptr) {
    u16 status;
    
    rq_delete_segment((SELECTOR)ptr, &status);
    ERR(status);
}

void *memcpy(void  *dst, const void *src, size_t len) {
    u_16 x;
    
    for(x=0; x<len; x++)
	*dst++ = *src++;
}
