#ifndef TYPES_H
#define TYPES_H

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;

#if defined(__NetBSD__)
#define SWAP16(word) ((u16)(((u16)word) >> 8) + (u16)(((u16)word) << 8))
#define SWAP32(dword) ((u32)(((u32)dword) >> 24) + (u32)(((u32)dword & 0x00FF0000) >> 8) + (u32)(((u32)dword & 0x0000FF00) << 8) + (u32)(((u32)dword) << 24))
#elif defined(__sun__)
#define SWAP16(word) (word)
#define SWAP32(dword) (dword)
#endif

#endif /* TYPES_H */
