/*
 * card.h
 */

/* ---------- Macros ---------- */
#define	CARD_HEIGHT	123
#define	CARD_WIDTH	79
#define CARD_SPACE      10

#define ROUND_H 7
#define ROUND_W 7

/* ---------- Structure definition ---------- */
typedef enum suit { spades = 0, clubs = 2, hearts = 1, diamonds = 3 } suit_e;
typedef enum pipnames { ace = 1, jack = 11, queen = 12, king = 13 } pipn_e;
typedef enum color { red = 1, black = 0 } color_e;

struct card {
     int cnum;			/* Number of card in pack */
     int invert:1;		/* Invert status.  */
};

/* ---------- Functions ---------- */
/*
 * card_create(suit, number) -> struct card *
 * 
 * Return a card with requested number and suit.
 */
struct card *card_create(int, int);

/*
 * card_create_from_int(number) -> struct card *
 * 
 * Return a card determined algorithmically from number.  The algorithm is
 * undefined, but it is guaranteed to return a unique card for all of the
 * numbers from 1 to 52 inclusive.
 */
struct card *card_create_from_int(int);

/*
 * card_destroy(card)
 * 
 * Destroy a card.
 */
#define card_destroy(c)  (free(c))

/*
 * card_suit(card) -> suit
 * 
 * Return the suit of a card.
 */
#define card_getsuit(c)  ((((c)->cnum) - 1) / 13)

/*
 * card_pips(card) -> int
 * 
 * Return the pips for a card.
 */
#define card_getpips(c)  (((((c)->cnum) - 1) % 13) + 1)

/*
 * card_color(card) -> color_e
 * 
 * Return the color of card.
 */
#define card_color(c)   (card_getsuit(c) % 2)

/*
 * card_draw(cardp, window, x, y)
 * 
 * Draw the requested card at position (x,y) in window.
 * As a special bonus hack, if cardp == NULL, then a space will be drawn for
 * an empty card.
 */
void card_draw(struct card *, struct wind *, int, int);

/*
 * card_setinvert(cardp, invert)
 * 
 * Set the invert status of the card to invert.
 */
void card_setinvert(struct card *, int);

/*
 * card_getinvert(cardp) -> int
 * 
 * Get the invert status of the card.
 */
#define card_getinvert(c)  ((c)->invert)

/*
 * card_setarea(cardp, areap)
 * 
 * Tell the card that it is being displayed in areap.
 */
#define card_setarea(c,a)  ((c)->ap = (a))

/*
 * card_getarea(cardp) -> struct area *
 * 
 * Get the area we're displayed in.
 */
#define card_getarea(c)  ((c)->ap)

/*
 * card_copy(cardp) --> struct card *
 * 
 * Make a copy of the card.  Return NULL if we fail.
 */
struct card *card_copy(struct card *);

/* ---------- Private function declarations ---------- */
/* pcard.c */
void paint_card(int, int, pipn_e, suit_e, int, int);

