.TH kgo 1 "5/93"
.SH NAME
kgo \- X Window System Interface for the Internet Go Server
.br
.SH SYNOPSIS
.in +.5i
.ti -.5i
.B
kgo [\-toolkitoption ...] [\-host igs\-hostname] [\-port igs\-port] [\-user
username] [\-password password] [\-whiteColor color] [\-blackColor color]
[\-lineColor color] [\-boardColor color]
.P
.in -.5i
.SH DESCRIPTION
.B "kgo"
provides an X Window System interface to the Internet
Go Server (IGS).  You may specify the location of the server with the 
.B \-host
and
.B \-port
arguments.  Your login name and password may be specified with the
.B \-user 
and 
.B \-password
arguments.  The Goban's colors may be specified with the 
.B \-whiteColor, \-blackColor, \-lineColor,
and
.B \-boardColor
arguments.

.SH RESOURCES
.B "kgo"
understands all of the core X Toolkit resource names and
classes as well as:
.\".in +1in
.TP 8
.B "host (\fPclass\fB Host)"
Specifies the name of the host to which 
.B "kgo"
should connect looing for the IGS.
.TP 8
.B "port (\fPclass\fB Port)"
Specifies the number of the port to which 
.B "kgo"
should connect looing for the IGS.
.TP 8
.B "userName (\fPclass\fB UserName)"
Specifies the username under which 
.B "kgo"
should log in.
.TP 8
.B "password (\fPclass\fB Password)"
Specifies the password with which 
.B "kgo"
should log in.

.SH "POINTER USAGE" 
Most gadgets should be self-explanatory.  On the
Goban, the left button attempts to make a move, and is disabled in
games which are being observed.  The middle button brings up a menu of
commands that manipulate the Go board.  The right button makes a
"hypothetical" move.  This is a move which is not committed in the
actual game, but rather makes a change in your local view of the game
to aid in looking ahead.  In fact, you may back up from the current
game position, locally "undoing" moves, and then make hypothetical
moves from that previous game position.  The "goto current move" menu
option throws out all such hypothetical moves, restoring the board to
reflect the actual game position that you most recently viewed; the
"last move" menu option restores the board to reflect the up-to-date
state of the game.

.SH "KEYBOARD USAGE"
If the pointer is in the lower window pane, then keystrokes are sent
to the IGS.  If the pointer is in the Goban, then keys
activate commands.  The keymap is:

.DT
.nf
	n	Create a new Goban window
	q	Quit this Goban window
	2\-9	Choose handicap (2 to 9)
	s	Back up to the start of the game
	b	Back up the game view by one move (does not undo)
	c	Goto current move
	f	Go forward one move
	l	Goto last move
	u	Undo last move
	p	Pass
	d	Done removing dead groups (used after game ends)
.fi


.SH "AUTHOR"
Ken Duda	 kkkken@athena.mit.edu
