#include "rt.h"
#include <ctype.h>
#include <iostream>

using std::cout;
using std::endl;

int MAX_BOUNCES;
int NUM_LIGHTS;

std::vector<Obj3D*> Objects;
Light ** Lights;

short AA;
Color4 Ambient;

double ParseDouble(std::string s)
{
	unsigned i = 0;
	bool Frac = false;
	double tot = 0;
	int places = 1;
	double tmp;
	int Sign = 1;
	if(s[0] == '-')
	{
		Sign = -1;
		i = 1;
	}
	for(;(isdigit(s[i]) || s[i] == '.') && i < s.length();i++)
	{
		if(!Frac && s[i] != '.')
		{
			tot *= 10;
			tot += s[i] - '0';
		}
		else if(s[i] == '.')
			Frac = true;
		else
		{
			tmp = s[i] - '0';
			for(int j = 0;j<places;j++)
				tmp /= 10;
			tot += tmp;
			places++;
		}
	}
	return Sign * tot;
}

void ParseVector(std::string s, Vector3D<> & vec)
{
	vec.V[0] = ParseDouble(s);
	s = s.substr(s.find_first_of(",")+1);
	vec.V[1] = ParseDouble(s);
	s = s.substr(s.find_first_of(",")+1);
	vec.V[2] = ParseDouble(s);
}

void ParseColor(std::string s, Color4 & col)
{
	col.C[0] = ParseDouble(s);
	s = s.substr(s.find_first_of(",")+1);
	col.C[1] = ParseDouble(s);
	s = s.substr(s.find_first_of(",")+1);
	col.C[2] = ParseDouble(s);
	int index = s.find_first_of(","); //Check to see if there is a fourth element (alpha)
	if(index >= 0)
	{
		s = s.substr(index+1);
		col.C[3] = ParseDouble(s);
	}
	else
		col.C[3] = 1.0;
}


void LoadScene(const char * filename)
{
	XMLTree Tree;
	Tree.Parse(filename);
	XMLNode * Head = Tree.GetHead();
	Assert(Head != NULL,std::string("Error loading ") + filename + ".\n");

	for(NodeIterator itr=Head->Children.begin();itr!=Head->Children.end();itr++)
	{
		if((*itr)->Name == "Objects")
			ParseObjects(*itr);
		else if((*itr)->Name == "Lights")
			ParseLights(*itr);
		else
			throw Exception("Unexpected 2nd-level scene node: " + (*itr)->Name);
	}
}

void ParseObjects(const XMLNode * on)
{
//	NUM_OBJECTS = on->Children.size();
//	PRINT(NUM_OBJECTS);
//	Objects = new Obj3D*[NUM_OBJECTS];
	for(NodeIterator itr = on->Children.begin();
		itr != on->Children.end();itr++)
	{
		if((*itr)->Name == "Sphere")
		{
			Objects.push_back(new Sphere);
		}
		else if((*itr)->Name == "Plane")
		{
			Objects.push_back(new Plane);
		}
		else
			throw Exception("Unexpected Object node: " + (*itr)->Name);
		Objects.back()->Load(*itr);
		if((*itr)->Properties["inverted"] == "yes")
			Objects.back()->Flip();
		if((*itr)->Properties["doublesided"] == "yes")
		{
			Objects.push_back(Objects.back()->NewCopy());
			Objects.back()->Flip();
		}
	}
}

/*void ParseSphere(XMLNode * sn, Sphere * s)
{
	DEBUG("Loading Sphere");
	for(NodeIterator itr=sn->Children.begin();
		itr != sn->Children.end();itr++)
	{
		PRINT((*itr)->Content);
		if((*itr)->Name == "Center")
		{
			ParseVector((*itr)->Content,s->Center);
			PRINT(s->Center);
		}
		else if((*itr)->Name == "Radius")
		{
			s->Radius = ParseDouble((*itr)->Content);
			PRINT(s->Radius);
		}
		else if((*itr)->Name == "Surface")
			s->Surf.Load(*itr);
		else if((*itr)->Name == "Inverted")
		{
			s->Outward = false;
   			DEBUG("Inverted");
		}
	}
}

void ParsePlane(XMLNode * pn, Plane * p)
{
	DEBUG("Loading Plane");
	for(NodeIterator itr=pn->Children.begin();
		itr != pn->Children.end();itr++)
	{
		PRINT((*itr)->Content);
		if((*itr)->Name == "Point")
		{
			ParseVector((*itr)->Content,p->Point);
			PRINT(p->Point);
		}
		else if((*itr)->Name == "Normal")
		{
			ParseVector((*itr)->Content,p->Normal);
			PRINT(p->Normal);
		}
		else if((*itr)->Name == "Surface")
			p->Surf.Load(*itr);
	}
}*/

void ParseLights(const XMLNode * ln)
{
	NUM_LIGHTS = 0;
	for(NodeIterator itr = ln->Children.begin();
	 itr != ln->Children.end(); itr++)
		if((*itr)->Name != "Ambient") NUM_LIGHTS++;

	Lights = new Light*[NUM_LIGHTS];

	int i = 0;
	for(NodeIterator itr = ln->Children.begin();
		itr != ln->Children.end(); itr++)
	{
		if((*itr)->Name == "Point")
		{
			Lights[i] = new PointLight;
		}
		else if((*itr)->Name == "Spot")
		{
			Lights[i] = new SpotLight;
		}
		else if((*itr)->Name == "Distant")
		{
			Lights[i] = new DistantLight;
		}
		else if((*itr)->Name == "JitteredPoint")
		{
			Lights[i] = new JitteredPointLight;
		}
		else if((*itr)->Name == "Ambient")
		{
			ParseColor((*itr)->Content,Ambient);
		}
		else
			throw Exception("Unexpected Light node: " + (*itr)->Name);
		if((*itr)->Name != "Ambient")
		{
			Lights[i]->Load(*itr);
			i++;
		}
	}
}

/*void ParseLight(const XMLNode * ln,Light * l)
{
	DEBUG("Loading Light");
	for(NodeIterator itr = ln->Children.begin();
		itr != ln->Children.end();itr++)
	{
		if((*itr)->Name == "Position")
		{
			ParseVector((*itr)->Content,l->Location);
			PRINT(l->Location);
		}
		else if((*itr)->Name == "Color")
		{
			ParseColor((*itr)->Content,l->Color);
			PRINT(l->Color);
		}
	}
}*/

void FreeScene()
{
	int i;
	for(i=0;i<NUM_LIGHTS;i++)
	{
		delete Lights[i];
	}
	delete[] Lights;

	for(i=0;i<NUM_OBJECTS;i++)
	{
		if(Objects[i]->Surf.Textured)
		{
			delete Objects[i]->Surf.Tex;
			delete Objects[i]->Surf.TexMap;
		}
		delete Objects[i];
	}
//	delete[] Objects;
}
