#include "XMLTree.h"
#include "expat.h"
#include <stack>
#include <fstream>
#include <iostream>

using std::cout; using std::endl;

//These callbacks are called by expat during the parse
void OnOpenTag(void * UserData, const XML_Char * name, const XML_Char ** atts);
void OnCloseTag(void * UserData, const XML_Char * name);
void OnData(void * UserData, const XML_Char * data, int len);

std::stack<XMLNode *, std::vector<XMLNode *> > Layers;
XMLNode * Top;

//These are internal methods and variables used in the XMLTree::Parse method.
//There should be no need for these to be accessed by users of the class

XMLNode * CreateXMLTree(const char * data, long len)
{
	XML_Parser p = XML_ParserCreate(NULL);
	XML_SetElementHandler(p,OnOpenTag,OnCloseTag);
	XML_SetCharacterDataHandler(p,OnData);
	if(XML_Parse(p,data,len,true))
	{
		return Top;
	}
	else
	{
		std::cout << "Expat Error:" << XML_ErrorString(XML_GetErrorCode(p))
				  << "(line " << XML_GetCurrentLineNumber(p) << ")"
      			  << std::endl;
		return NULL;
	}
}

void OnOpenTag(void * UserData, const XML_Char * name, const XML_Char ** atts)
{
	XMLNode * n = new XMLNode;
	n->Name = name;
	int i;
	for(i=0;atts[i] != NULL;i+=2)
		n->Properties[atts[i]] = atts[i+1];
	if(Layers.empty())
		Top = n;
	else
		Layers.top()->Children.push_back(n);
	Layers.push(n);
}

void OnCloseTag(void * UserData, const XML_Char * name)
{
	Layers.pop();
}

void OnData(void * UserData, const XML_Char * data, int len)
{
	for(int i=0;i<len;i++)
		Layers.top()->Content += data[i];
	//cout << Layers.top()->Name << " Got content " << Layers.top()->Content << endl;
}

XMLNode::~XMLNode()
{
	std::vector<XMLNode*>::iterator i = Children.begin();
	for(;i!=Children.end();i++)
		delete (*i);
}

XMLTree::XMLTree()
{
	Head = NULL;
}

XMLTree::~XMLTree()
{
	delete Head;
}

void XMLTree::Parse(const char *filename)
{
	std::ifstream fin(filename);
	long flen;
	char * fdata;
	
	if(!fin)
	{
		std::cout << "Unable to open file" << std::endl;
		return;
	}

	fin.seekg(0,std::ios::end);
	flen = fin.tellg();
	fin.seekg(0,std::ios::beg);
	fdata = new char[flen];
	fin.read(fdata,flen);
	fin.close();
	
	Head = CreateXMLTree(fdata,flen);
	delete [] fdata;
}
