
/*****************************************************************************
 *
 * Microchip DeviceNet Stack 
 * (Network Access State Machine management header)
 *
 *****************************************************************************
 * FileName:        NASM.h
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.10.02 or higher
 * Linker:          MPLINK 03.20.01 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains the Network Access State Machine (NASM) managing 
 * functions. All the functions work closely with the Duplicate ID messaging
 * provided by the connection object.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			06/06/03	...	
 * 
 *****************************************************************************/



#define	_NASM_AUTOBAUD		0
#define	_NASM_SENDING_DID	1
#define	_NASM_WAITING_DID	2
#define	_NASM_ON_LINE		3
#define	_NASM_COMM_FAULT	4

#define	NASM_AUTOBAUD		0
#define	NASM_SENDING_DID	1
#define	NASM_WAITING_DID	2
#define	NASM_ON_LINE		3
#define	NASM_COMM_FAULT		4





#if USE_ACCESS == 1
#pragma	udata access	_A_GO_DNET_FUNCTIONS
#endif

extern NEAR USINT	_aNASMStates;


/*********************************************************************
 * Function:        void _NASMAutoBaudStateManager(void)
 *
 * PreCondition:  	none  
 *
 * Input:       	none			
 *                  
 * Output:     		none
 * 	
 * Side Effects:   	none 
 *
 * Overview:        This function attempts to determine the baud rate
 *					by using the Duplicate ID messaging.  
 *
 * Note:            none
 ********************************************************************/
//void _NASMAutoBaudStateManager(void);


/*********************************************************************
 * Function:        void _NASMSendingDupIDStateManagder(void)
 *
 * PreCondition:  	none  
 *
 * Input:       	none			
 *                  
 * Output:     		none
 * 	
 * Side Effects:   	none 
 *
 * Overview:        This function manages Duplicate ID messaging while
 *					in the Sending Duplicate ID state.  
 *
 * Note:            none
 ********************************************************************/
void _NASMSendingDupIDStateManagder(void);

/*********************************************************************
 * Function:        void _NASMWaitingForDupIDStateManager(void)
 *
 * PreCondition:  	none  
 *
 * Input:       	none			
 *                  
 * Output:     		none
 * 	
 * Side Effects:   	none 
 *
 * Overview:        This function manages Duplicate ID messaging while
 *					in the Waiting for Duplicate ID state.  
 *
 * Note:            none
 ********************************************************************/
void _NASMWaitingForDupIDStateManager(void);

/*********************************************************************
 * Function:        void _NASMOnLineStateManager(void)
 *
 * PreCondition:  	none  
 *
 * Input:       	none			
 *                  
 * Output:     		none
 * 	
 * Side Effects:   	none 
 *
 * Overview:        This function manages Duplicate ID messaging while
 *					in the on-line state.  
 *
 * Note:            none
 ********************************************************************/
void _NASMOnLineStateManager(void);


/*********************************************************************
 * Function:        void _NASMWaitTimeManager(void)
 *
 * PreCondition:  	none  
 *
 * Input:       	none			
 *                  
 * Output:     		none
 * 	
 * Side Effects:   	none 
 *
 * Overview:        This funcion adjusts the Network Access State 
 *					Machine timer.  
 *
 * Note:            none
 ********************************************************************/
void _NASMWaitTimeManager(void);

/*********************************************************************
 * Function:        void _NASMWriteDuplicateID(void)
 *
 * PreCondition:    
 *
 * Input:       			
 *                  
 * Output:     
 * 	
 * Side Effects:    
 *
 * Overview:        Write the Vendor ID and Serial number to the
 *					transmit buffer.  
 *
 * Note:            None
 ********************************************************************/
void _NASMWriteDuplicateID(NEAR unsigned char portNoAndReq);


/*********************************************************************
 * Function:        void _NASMInit(void)
 *
 * PreCondition:    
 *
 * Input:       			
 *                  
 * Output:     
 * 	
 * Side Effects:    
 *
 * Overview:        Initialize the Network Access State Machine.  
 *
 * Note:            None
 ********************************************************************/
void _NASMInit(void);

#define	mNASMGetState()	(_aNASMStates)


#pragma	udata
