// -*- mode: java; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*-

package antichess;

/**
 * An <tt>Exception</tt> thrown when a client asks a <tt>Board</tt> to
 * make an illegal move.
 *
 * @specfield move : Move // The illegal move 
 **/
public class IllegalMoveException extends Exception
{
    private Move move;     // Ve do not believe in you

    /**
     * @effects create an IllegalMoveException with the given Move
     */
    public IllegalMoveException(Move m) {
        super("Illegal move: " + m.toString());
        this.move = m;
    }

    /**
     * @return this.move
     */
    public Move getMove() {
        return move;
    }
}
