// -*- mode: java; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*-

package antichess.ai;

import antichess.*;
import java.util.*;

/**
 * <code>AntichessAI</code> implements an Antichess AI
 **/
public class AntichessAI extends MinimaxAI<ChessMove, AntichessBoard>
{
	private Map<PieceType, Integer> pieceValues;

	public AntichessAI() {
		pieceValues = new HashMap<PieceType, Integer>();
		pieceValues.put(PieceTypeFactory.getPawnType(), 5);
		pieceValues.put(PieceTypeFactory.getKnightType(), 3);
		pieceValues.put(PieceTypeFactory.getBishopType(), 3);
		pieceValues.put(PieceTypeFactory.getRookType(), 3);
		pieceValues.put(PieceTypeFactory.getQueenType(), 3);
		pieceValues.put(PieceTypeFactory.getKingType(), 0);
	}
	
    public int boardValue(AntichessBoard board) {
		if(board.isGameOver()) {
			switch(board.getWinner()) {
			case WHITE:
				return Integer.MAX_VALUE / 2;
			case BLACK:
				return Integer.MIN_VALUE / 2;
			default:
				return 0;
			}
		}
		int value = 0;
		for(Piece p : board.getPieces()) {
			if(p.getPlayer() == Player.WHITE)
				value -= pieceValues.get(p.getType());
			else
				value += pieceValues.get(p.getType());
		}
		return value;
	}
}
