
package antichess.viewgui;

import java.awt.Component;

import antichess.Board;
import antichess.HumanPlayer;

/**
 * BoardView is a container for rendering Boards and accept input.
 * It is an abstract class that is meant to be subclassed by classes
 * that are meant to render specific types of Boards.
 * 
 * @author nlharr
 * @specfield acceptingInput	//boolean that stores whether the BoardView is accepting input
 * 								//boardPlayer.setView(args) can only be called by this BoardView
 * 								//when acceptingInput == true
 * 
 * @specfield boardPlayer		//the HumanPlayer that is requesting inputr from the BoardView
 * @specfield viewedBoard		//the board that this BoardView is displaying
 */

public abstract class BoardView extends Component{
	
	
	/**
	 * Sets the BoardView to accept input from the humanPlayer
	 * If the BoardView is already accepting input this call does nothing
	 * @modifies acceptingInput, boardPlayer
	 * @effects acceptingInput = true, boardPlayer = humanPlayer
	 */
	public void setAcceptingInput(HumanPlayer humanPlayer){}
	
	/**
	 * Sets the BoardView to not accept input
	 * @modifies acceptingInput
	 */
	public void setNotAcceptingInput(){}
	
	/**
	 * Notifies the BoardView that the board has changed
	 *
	 */
	public void postRefresh(){}
	

}