package antichess.viewgui;

import java.text.DecimalFormat;

import javax.swing.BorderFactory;
import javax.swing.JLabel;

import antichess.GameClock;
import antichess.GameTimerListener;
import antichess.Player;
/**
 * A TimerLabel is a JLabel automatically refreshed by a ChessClock
 * It displays the time in a minutes:seconds format.  If the specified
 * ChessClock does not contain a timer for this player the TimerLabel
 * displays the word Untimed. 
 * 
 * @author nlharr
 *
 */
public class TimerLabel extends JLabel implements GameTimerListener{
	//Fields
	//stores whether the GameClock has a timer for this player
	private boolean hasTimer;
	
	
	
	/**
	 * Constructs a new TimerLabel that listens to a TimerLabel contained
	 * in a GameClock
	 * 
	 * If the clock does not have a player associated with the 
	 * 
	 */
	public TimerLabel(GameClock clock, Player player){
		super();
		if (!clock.hasPlayer(player)){
			hasTimer = false;
			this.setText("<html><font size=+2>Untimed</font>");
			
		}else{
			hasTimer = true;
			clock.addListener(this, player);
			this.setText("<html><font size=+3>"+getTimeFormat(clock.getTime(player))+"</font>");
		}
		this.setBorder(BorderFactory.createTitledBorder("Time Left"));
		
	}
	/**
	 * Refreshes the text value displayed in the field
	 */
	public void refreshTimer(long times){
		if (hasTimer){
			this.setText("<html><font size=+3>"+getTimeFormat(times)+"</font>");
		}		
	}
	/**
	 * @return a string that formats the inp in milliseconds into a 
	 * proper time format "##:0#" minutes:seconds
	 */
	public String getTimeFormat(long inp){
		DecimalFormat secondFormatter = new DecimalFormat("00");
		DecimalFormat minuteFormatter = new DecimalFormat("#0");
		
		String minutes = minuteFormatter.format(Math.floor(inp/60000));
		String seconds = secondFormatter.format(Math.floor((inp-60000*Math.floor(inp/60000))/1000));
		return minutes+":"+seconds;
	}
	
	
	
}
