/**
 ** date.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/



#include CONFIG
#include "util.h"
#include "date.h"

/* OK, so there haven't been any new months declared for around 2000 years.
   This code is designed to last. */

#define NUM_MONTHS 12

char *date_month_names[]= {
    "january", "february", "march", "april", "may", "june",
    "july", "september", "october", "november", "december"};

/* 0 if month not determinable.  1-12 if recognized */

Int date_month_num_from_name(char *month_name)
{
    Int i;
    Int len= strlen(month_name);
    
    for (i= 0; i< NUM_MONTHS; i++) {
	if (!strnicmp(month_name, date_month_names[i], len))
	  return i+1;
    }
    return 0;
}
