/**
 ** table.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/

/**
 ** table.h
 **
 ** Associative table, implemented as a sorted vector
 ** search time O(log N), insertion/deletion time O(N)
 **
 ** v1.0  Thu May 16 1991 Randy Sargent created
 ** v1.1  Fri Aug  9 1991 Randy Sargent
 **             added table_remove, table_get_key_and_value     
 **/

#ifndef TABLE_H
#define TABLE_H

typedef struct table_str {
    Int num_elems;
    Int max_elems;
    Int key_size;
    Int elem_size;
    Int (*compare)(void*, void*);
    char *elems;
} Table;

typedef Int TableIter;

#include "table.pro"

#endif   /* #ifndef TABLE_H */
