/**
 ** io.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#ifndef IOB_H
#define IOB_H

extern char *io_default_serial_name;
extern Int io_debug;
extern Int io_hex_on_serial, io_delay_factor;

#if defined(UNIX)
#include "iob_unix.h"
#elif defined(PC)
#include "iob_pc.h"
#elif defined(MAC)
#include "iob_mac.h"
#else
#error
#endif

#ifdef HAS_TCSETATTR
#define USE_TERMIOS
#endif

/* timeout= 0 means return immediately */
/* timeout < 0 means wait indefinitely for a character */

/* machine independent stuff here: */

#define IOSTREAM_NAME_MAX 100

#ifndef IOSTREAM_DEFINED
#define IOSTREAM_DEFINED
typedef struct iostream_struct {
    char name[IOSTREAM_NAME_MAX];
    QUEUE1
    QUEUE2
    Int extended_charset;
    Int prefix_detected;
    FIELD1
    FIELD2
    FIELD3
    FIELD4
} IOStream;
#endif


extern Int io_debug, io_disable_xy;

#if defined(UNIX)
#include "iob_unix.pro"
#elif defined(PC)
#include "iob_pc.pro"
#elif defined(MAC)
#include "iob_mac.pro"
#else
#error
#endif

#include <iob.pro>

#endif   /* #ifndef IOB_H */
