/* macargs.c */

#include CONFIG
#include <util.h>
#include <mac-args.h>
#include <Resources.h>
#include <Memory.h>
#include <Events.h>

Int argc;
char *argv[50];
char argv_buf[1000];

void mac_get_args(char *prog_name, char *default_argline, void (*func)(char **argv))
{
	char *resource_args= get_resource_string("\pargs");
	
	printf("Hold down SHIFT to change startup arguments\n");
	
	if (resource_args && resource_args[0]) {
		printf("Program args from resource: %s\n", resource_args);
		mac_make_argv(prog_name, resource_args);
		msleep(1000);
	} else {
		if (!resource_args) printf("Resource args (STR :args) not found\n");
		else printf("Resouce args are blank\n");
		strcpy(argv_buf, "-prompt_user");
		mac_make_argv(prog_name, argv_buf);
	}
	if (!strcmp(argv[1], "-prompt_user")) {
	get_args_from_user:
		if (func) {
			printf("\n");
			(*func)(argv);
		}
		printf("\nPlease type in command-line arguments\n");
		printf("(Note that the default args can be set using ResEdit)\n");
		printf("Default: %s\n", default_argline);
		mac_get_line(argv_buf);
		if (argv_buf[0]==0) {
			strcpy(argv_buf, default_argline);
		}
		printf("Using args %s\n", argv_buf);
		mac_make_argv(prog_name, argv_buf);
		msleep(1000);
	} else {
		msleep(1000);
		if (is_shift_key_pressed()) {
			goto get_args_from_user;
		}
	}
	printf("\n");
}

void mac_get_line(char *in)
{
    Int c;
    while (((c= getchar()) != '\n') && c != EOF) *in++= (char) c;
    *in= 0;
}

Int is_shift_key_pressed(void)
{
	return is_key_pressed(0x38); /* shift */
}

Int is_key_pressed(Int k)
{
	unsigned char keymap[16];
	GetKeys(keymap);
	return ((keymap[k>>3]>>(k&7))&1);
}

void mac_make_argv(char *progname, char *argv_line)
{
    char *bufptr;
    Int i;
    i= 0;
    argv[i++]= progname;
    for (bufptr= argv_line, i<49; 1; i++) {
    	if (strchr(bufptr, ' ')) {
    	   argv[i]= bufptr;
    	   bufptr= strchr(bufptr, ' ');
    	   *bufptr= 0;
    	   bufptr++;
    	} else {
    	   if (*bufptr) argv[i++]= bufptr;
    	   break;
    	}
    }
    argv[i]= 0;
    argc= i;
}

char *get_resource_string(unsigned char *name)
{
	char **s= (char**)GetNamedResource('STR ', name);
	if (!s) {
		return NULL;
	} else {
		char *str;
		Int len;
		char *ret;
		
		HLock(s);
		str= *s;
		len= str[0] & 255;
		ret= malloc(1 + len);
		memcpy(ret, str+1, len);
		ret[len]= 0;
		HUnlock(s);
		return ret;
	}
}

	
	
