/* named_sockets.c */

#include CONFIG

#include <common.h>
#include <table.h>

#include <signal.h>

#include <stdio.h>
#include <fcntl.h>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <signal.h>
#include <sys/socket.h>


#include "named_socket_server_lib.h"
#include "named_socket_client_lib.h"
#include "socket_server.pro"

/* To use the named socket server, you connect to the server port, and
   then immediately send one of the following lines.  (The server currently
   wedges until it gets the line)

   find portname
      Example:  find multiterm.term.*
                which might yield
                6550 multiterm.term.ttya
                6551 multiterm.term.ttyb
                end
   assign portname [portnumber]
      This will assign a name to a number.  If the number isn't specified,
      a free number will be taken at random
      Example:  assign multiterm.term.ttyc
                which might yield
                6566 multiterm.term.ttyc
                Note that if it's already assigned, it will become
                reassigned
                
   die
      Kill the named socket server
   delete portname [portnumber]
      This will delete the mapping from portname to its portnumber.  If
      portnumber is specified, the mapping will not be deleted unless
      the portnumber specified is in fact the current mapping

*/

int server_socket;

Table server_table;


void handle_sigpipe(void)
{
  if (debug_named_sockets) 
    fprintf(stderr, "Caught a sigpipe\n");
}

int find_unused_port(void)
{
  int ret= next_port_to_assign;
  next_port_to_assign++;
  return ret;
}

void server_assign(int fd, char *name, int port)
{
  char *name_copy= string_copy(name);
  if (port < 1) port= find_unused_port();
  if (debug_named_sockets) fprintf(stderr, "Adding %s -> %d\n", name, port);
  table_set(&server_table, &name_copy, &port);
  if (debug_named_sockets) 
    table_display(&server_table, table_print_str, table_print_int);
  server_find(fd, name);
}

void server_find(int fd, char *look_for)
{
  TableIter i;
  char **name;
  int *port;
  table_rewind(&server_table, &i);
  while (table_get_next(&server_table, &i, &name, &port)) {
    int m= match(*name, look_for);
    if (debug_named_sockets) 
      fprintf(stderr, "r(%s,%s)->%d\n", *name, look_for, m);
    if (m) {
      fd_printf(fd, "%d %s\n", *port, *name);
    }
  }
  fd_printf(fd, "end\n");
}

int match(char *str, char *pattern)
{
  if (*pattern == 0) {
    if (*str == 0) return 1;
    return 0;
  }
  else if (*pattern == '*') {
    pattern++;
    while (1) {
      if (match(str, pattern)) return 1;
      if (!*str) return 0;
      str++;
    }
  }
  else if (*pattern == *str) {
    return match(str+1, pattern+1);
  }
  else return 0;
}
      
void server_delete(int fd, char *name, int port)
{
  fd_printf(fd, "Feature not yet implemented\n");
}

void start_named_socket_server(void)
{
  signal(SIGPIPE, (void*) handle_sigpipe);
  table_init(&server_table, sizeof(char*), sizeof(int), table_strcmp);
  server_socket= socket_server_init(0, server_port);
  while (1) {
    int fd;
    char buf[200];
    char arg0[200],arg1[200],arg2[200];

    if (debug_named_sockets) 
      fprintf(stderr, "Waiting for connection on port %d\n", server_port);
    fd= socket_server_accept(0);
    if (debug_named_sockets) fprintf(stderr, "Got a connection\n");
    
    readln(fd, buf, 199);

    if (debug_named_sockets) fprintf(stderr, "Command: %s\n", buf);
    arg0[0]=0;arg1[0]=0; arg2[0]=0;
    sscanf(buf, "%s %s %s", arg0, arg1, arg2);
    if (!strcmp(arg0, "find")) {
      server_find(fd, arg1);
    }
    else if (!strcmp(arg0, "assign")) {
      server_assign(fd, arg1, arg2[0] ? atoi(arg2) : -1);
    }
    else if (!strcmp(arg0, "die")) {
      exit(-1);
    }
    else if (!strcmp(arg0, "delete")) {
      server_delete(fd, arg1, arg2[0] ? atoi(arg2) : -1);
    }
    else {
      fd_printf(fd,"Illegal command %s\n", arg0);
    }
    close(fd);
  }
}

void set_socket_options(int socket)
{
  /*setsockopt(socket, SO_KEEPALIVE, SO_REUSEADDR) */
}

/* Start up a connection to a local name server.  If there is no
  local name server, start one up */

int connect_to_local_name_server(void) 
{
  int server;
  int server_started= 0;
  while (1) {
    server= connect_to_name_server("localhost");
    if (server) break;
    if (!server_started)  {
      fprintf(stderr, "No named socket server running.  Starting one\n");
      start_named_socket_server_in_background();
    }
    else {
      fprintf(stderr, "Waiting for server to come up\n");
    }
    sleep(1);
  }
  return server;
}

void start_named_socket_server_in_background(void)
{
  system("named_socket_server &");
}

/* Send port = -1 if you want the port # to be dynamically 
  assigned by the server (this is what you should usually do)
   Returns -1 if error */

int assign_named_socket(char *name, int port)
{
  int server= connect_to_local_name_server();
  int ret_port= -1;
  char buf[200];

  if (server <= 0) {
    fprintf(stderr, "Couldn't connect to local name server\n");
    goto end;
  }
  
  if (port > 0) {
    fd_printf(server, "assign %s %d\n", name, port);
  }
  else {
    fd_printf(server, "assign %s\n", name);
  }
  write(server, buf, strlen(buf));

  readln(server, buf, 200);
#if 0
  if (debug_named_sockets) {
    fprintf(stderr, "response: <%s>\n", buf);
  }
#endif
  if (sscanf(buf, "%d", &ret_port) != 1) {
     fprintf(stderr, "Didn't get a response from local name server\n");
     fprintf(stderr, "(Got >%s<\n)", buf);
     ret_port= -1;
     goto end;
  }
  if (ret_port <= 0) {
    fprintf(stderr, "Got an illegal port from the local name server\n");
    goto end;
  }
  if (debug_named_sockets) {
    fprintf(stderr, "Assigned %s to port %d\n", name, ret_port);
  }
 end:
  if (server > 0) close(server);
  return ret_port;
}
  


    
  
  
  
    


  


