/**
 ** stream.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/

/**
 **  stream.c
 **
 ** v1.0  Sat May 18 13:46:06 1991  Randy Sargent.  created
 **/

#include CONFIG

#include "util.h"
#include "stream.h"

#define STREAM_BUFFER_SIZE 1024

Int stream__init(Stream *s, char *string, void *data,
		 Int (*replenish)(void* buf, size_t item_size, size_t nitems, void* data),
		 Int (*seek)(void *data, long offset, int offset_type)
		 );

/* 0 if successful */
Int stream_init_from_string(Stream *s, char *string)
{
    return stream__init(s, string, 0, 0, 0);
}

/* 0 if successful */
Int stream_init_from_file(Stream *s, FILE *file)
{
    return stream__init(s, 0, file,
		        (Int (*) (void*, int, int, void*)) fread,
		        (Int (*) (void*, long, int)) fseek);
}
    
/* 0 if successful */
Int stream__init(Stream *s, char *string, void *data,
		 Int (*replenish)(void* buf, size_t item_size, size_t nitems, void* data),
		 Int (*seek)(void *data, long offset, int offset_type))
{
    s->data= data;
    s->buffer= string;
    s->replenish= replenish;
    s->seek= seek;

    if (!!s->buffer + !!s->replenish != 1)
      die(("Must give one and only one of string or replenish to stream__init"));

    if (string) {
	s->buffer_size= strlen(string);
	s->buffer_ptr= string;
    }
    else {
	s->buffer_size= 0;
	s->buffer= malloc(STREAM_BUFFER_SIZE + 1);
	if (!s->buffer) return 1;
	s->buffer_ptr= s->buffer;
	s->buffer[0]= 0;
    }

    return 0;
}

void stream_term(Stream *s)
{
    long bytes_left= s->buffer_size - (s->buffer_ptr - s->buffer);
    if (s->seek && bytes_left) {
	(*(s->seek))(s->data, (long) -bytes_left, 1);
    }
    if (s->data || s->replenish) {
	free(s->buffer);
    }
    s->buffer= 0;
}

Int stream_getc(Stream *s)
{
    if (*s->buffer_ptr) return *s->buffer_ptr++;
    
    if (s->buffer_ptr - s->buffer >= s->buffer_size) {
	if (s->data) {
	    s->buffer_size= (s->replenish)(s->buffer, 1,
					   STREAM_BUFFER_SIZE,
					   s->data);
	    s->buffer_ptr= s->buffer;
	    s->buffer[s->buffer_size]= 0;
	    if (s->buffer_size == 0) return EOF;
	} else {
	    return EOF;
	}
    }

    return *s->buffer_ptr++;
}


