/**
 ** util.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#ifndef UTIL_H
#define UTIL_H

/* #define MALLOC_DEBUG */ /* this is now moved to config.h */

extern void* util_unused;

/*-------------------------------------------------------------------------*/
/* Public Macros                                                           */

#define debug_out(args) printf args

#define debug(module, args) \
  do { \
      if (module ## _debug) { \
	  printf("%s: ", #module); \
	  printf args ; \
      } \
  } while(0)

#ifdef __SABER__
#define DIE() (centerline_stop(), exit(-1))
#define UNUSED(arg) util_unused= &(arg)
#else
#define UNUSED(arg) util_unused= &(arg)
#define DIE() {util_unused= *(char**)(-1);exit(-1);}
#endif
  
#define die(args) \
  do { \
    printf("Fatal internal error:\n"); \
    printf args ; \
    printf("\n"); \
    DIE(); \
  } while(0)

#define unimplemented(string) \
  do { \
    printf("%s unimplemented (sorry), file %s(%d)\n", string, __FILE__, __LINE__); \
    DIE(); \
  } while(0)

#define assert(expression) ASSERT(expression)
#define ASSERT(expression) \
  do { \
    if (!(expression)) { \
      fprintf(stderr, "\n%s(%d): Assertion failed\n", __FILE__, __LINE__); \
      DIE(); \
    } \
  } while(0)

#define CHECK(expression) \
  do { \
    if ((expression)) { \
      printf("\n%s(%d): check failed\n", __FILE__, __LINE__); \
      DIE(); \
    } \
  } while(0)
    
#define NOPROTO

#ifdef NEED_STRICMP
int stricmp (char *a, char *b);
#endif

#ifdef HAS_STRCASECMP
int stricmp (char *a, char *b);
#endif

#ifdef NEED_STRNICMP
int strnicmp (char *a, char *b, int n);
#endif

#ifdef HAS_STRNCASECMP
int strnicmp (char *a, char *b, int n);
#endif


#ifndef MALLOC_DEBUG
typedef int Malloc_ptrs;

#else
#define MAX_MALLOCS 16384

typedef struct malloc_debug_struct {
  void *mptr;
  Int size;
  const char *file;
  Int line;
  Int time;
  Int logtime;
  long c0;
  long c1;
  long c2;
  char break_on_free;
} Malloc_ptrs;

extern Malloc_ptrs malloc_tab[];
extern Int mtablen;

#ifdef malloc
#undef malloc
#endif

#ifdef realloc
#undef realloc
#endif

#ifdef free
#undef free
#endif

#define malloc(x) (debug_malloc(x, __FILE__, __LINE__))
#define realloc(x,y) (debug_realloc(x,y, __FILE__, __LINE__))
#define free(x) (debug_free(x, __FILE__, __LINE__))
#endif

extern Int dmalloc_debug;
extern Int debug_malloc_lognum;

#include "util.pro"

#ifdef MALLOC_DEBUG
#define xmalloc(x) (debug_xmalloc(x, __FILE__, __LINE__))
#endif

#endif   /* #ifndef UTIL_H */

