/******************************************************************
 * AUTO Paranoia IV
 * CopyPolicy: GNU Public License 2 applies
 * (C) 1998 Monty xiphmont@mit.edu
 * 
 * Linux toplevel autosense includes and config
 *
 ******************************************************************/

#ifdef LINUX

#include "auto_paranoia.h"

struct auto_procdevifs{
  int targetinterface;
  int targethardtype;
  int targetpacktype;
  transport_device (*trans_open)(int,void(*)(int,int,void*));
};

/* general information about the devices on a platform indexed by procdev. */

typedef struct auto_procdev{
  char *procdev;
  char *desc;
  struct auto_procdevifs *ifs[];
} auto_procdev;

/* general information about the devices on a platform, indexed by likely
   /dev entries.  This includes some likely interface information to cut
   down on the search space, but 'likely' hits then gerally need to look
   up specifics by procdev entry */

typedef struct auto_devfiles{
  int iffamily;
  int packetype;
  int hardtype;
  char *procdev; /* NULL if there's no one specific procdev that's most likely.
		    This field is to be used only as a fallback in autodetect
		    if procdev isn't available by other means. */
  
  char *prompt;
  char *devices[];
}

/* many /proc device types.  Fewer supported interfaces. */
struct auto_procdevifs __pi_linux_sg={
  IFFAMILY_SCSIGENERIC,
  HARDTYPE_WILDCARD,    /* could be anything.  Have to sense */
  PACKET_SCSI,
  &linuxsg_open
};

struct auto_procdevifs __pi_linux_pg={
  IFFAMILY_PARIDEGENERIC,
  HARDTYPE_WILDCARD,    /* could be anything.  Have to sense */
  PACKET_SCSI,
  &linuxpg_open
};

struct auto_procdevifs __pi_linux_idecooked={
  IFFAMILY_IDESPECIAL,
  HARDTYPE_WILDCARD,    /* could be anything.  Have to sense */
  PACKET_COOKED,
  &linuxioctl_open
};

struct auto_procdevifs __pi_linux_cdromcooked={
  IFFAMILY_PROPSPECIAL,
  HARDTYPE_CDROM,
  PACKET_COOKED,
  &linuxioctl_open
};


/* fairly complete list of Linux proc device entries. */

auto_procdev *auto_procdevs[]={ 
  {"ide0",   "primary IDE/ATAPI",
   {&__pi_linux_idecooked,NULL}},
  
  {"ide",  "secondary IDE/ATAPI",
   {&__pi_linux_idecooked,NULL}},
  
  {"sd",   "SCSI hard disk",
   {NULL}},
  
  {"sr",   "SCSI CD-ROM drive",
   {NULL}},
  
  {"st",   "SCSI tape",
   {NULL}},
  
  {"sg",   "SCSI generic",
   {&__pi_linux_sg,NULL}},
  
  "pd",   "PARIDE hard disk",
			"pf",   "PARIDE floppy",
			"pcd",  "PARIDE CD_ROM drive",
			"pg",   "PARIDE generic"
			"pt",   "PARIDE tape",

			"fd",          "floppy disk",
			"loop",        "loopback",
			"hd",          "IDE hard disk (old interface)",
			"ht",          "IDE tape",
			"md",          "multple dev interface/raid",
			"ramdisk",     "ramdisk",
			"xd",          "XT hard disk",

			"fb",          "framebuffer",
			"lp",          "parallel port",
			"staliomem",   "stallion multiport",
			"mem",         "memory",
			"misc",        "miscellaneous",
			"tpqic02",     "QIC tape drive",
			"tty",         "teletype",
			"pty",         "pseudo-teletype",
			"cua",         "serial",
			"vcs",         "virtual console",
			"sound",       "sound",
			"snd",         "sound",

			"isdn",        "ISDN",

			"aztcd",       "aztech proprietary CD-ROM drive",
			"cdu31a",      "Sony cdu31a proprietary CD-ROM drive",
			"cm206",       "cm206 proprietary CD-ROM drive",
			"gscd",        "Goldstar R420 CD-ROM drive",
			"mcd",         "Mitsumi proprietary CD-ROM drive",
			"optcd"        "Optics proprietary CD-ROM drive",
			"sbpcd",       "SoundBlaster CD-ROM drive",
			"sjcd",        "Sanyo proprietary CD-ROM drive",
			"cdu535",      "Sony cdu535 proprietary CD-ROM drive",

                        NULL,   NULL};








/* automated search list to drive platform-independent searcher.  We
   use search using all the entries that match our search criteria,
   and accept the appropriate devices found */

struct auto_devfiles[]={ {IFFAMILY_WILDCARD, PACKET_WILDCARD, HARDTYPE_CDROM,
		       "/dev/cdrom link",{"/dev/cdrom"}},

		      {IFFAMILY_WILDCARD, PACKET_WILDCARD, HARDTYPE_CDROM,
		       "/dev/cdrom* links",{"/dev/cdrom?"}},

		      {IFFAMILY_IDESPECIAL, PACKET_WILDCARD, HARDTYPE_CDROM,
		       "IDE/ATAPI devices",{"/dev/hd?"}},

		      {IFFAMILY_SCSIGENERIC, PACKET_WILDCARD, HARDTYPE_CDROM,
		       "GENERIC SCSI devices",{"/dev/sg?"}},

		      /* we really want the generic devices, but if we
                         search and find specialized SCSI CDROMs (and
                         not generic devices), we can report this to
                         the user */
		      {IFFAMILY_SCSIGENERIC, PACKET_WILDCARD, HARDTYPE_CDROM,
		       "GENERIC SCSI devices via SCSI CDROM devices",
		       {"/dev/sr?","/dev/scd?"}},

		      {IFFAMILY_PARIDEGENERIC, PACKET_WILDCARD, HARDTYPE_CDROM,
		       "GENERIC parallel port IDE devices",{"/dev/pg?"}},

		      {IFFAMILY_PROPSPECIAL, PACKET_WILDCARD, HARDTYPE_CDROM,
		       "proprietary interface devices",
		       {"/dev/cdu31a","/dev/cdu535",
			"/dev/sbpcd","/dev/sbpcd?","/dev/sonycd",
			"/dev/mcd","/dev/sjcd",
			/* "/dev/aztcd", timeout is too long */
			"/dev/cm206cd",
			"/dev/gscd","/dev/optcd"}},

		      NULL};

#endif
