/******************************************************************
 * AUTO Paranoia IV
 * CopyPolicy: GNU Public License 2 applies
 * (C) 1999 Monty xiphmont@mit.edu
 * 
 * Linux-specific additions to report database
 *
 ******************************************************************/

#ifdef LINUX

void __pi_auto_callback_platform(report_base *r){
  char *r1="Unable to open device file \"%9\"; the device file exists and"
    " is accessible, but the kernel reported it had no"
    " support configured (or enabled) for this device's major number."
    "  This could be due to %10 kernel/module support not being selected,"
    " or %10 hardware not actually existing; modules generally won't load when"
    " the hardware is missing.";

  char *r2="Unable to open device file \"%9\"; the device file exists and"
    " is accessible, but Paranoia does not recognize the device type and "
    "the kernel reported it had no"
    " support configured (or enabled) for this device's major number."
    "  This could be due to kernel/module support not being selected,"
    " or the hardware not actually existing; modules generally won't load when"
    " the hardware is missing.";

  auto_report_add(r,r1,"1","*","*","1", P_ERROR_ENODEV,IFFAMILY_WILDCARD,
		  HARDTYPE_WILDCARD,A_STATE_WILDCARD,"*");

  auto_report_add(r,r2,"1","*","*","1", P_ERROR_ENODEV,IFFAMILY_UNKNOWN,
		  HARDTYPE_WILDCARD,A_STATE_WILDCARD,"*");

  auto_report_add(r,"Paranoia was not able to retrieve the bus:target:lun "
		  "numbers for %10 cdrom device \"%9\" from the "
		  "kernel; this is likely due to this version of Linux not "
		  "having the SCSI_IOCTL_GET_IDLUN ioctl() call.  Without "
		  "this support, Paranoia cannot automap \"%9\" to a "
		  "matching %10 device for use.  Please specify "
		  "the desired generic (/dev/sg*) device explicitly. ",
		  "1","*","*","1",P_ERROR_BTL,IFFAMILY_SCSIGENERIC,
		  HARDTYPE_WILDCARD,A_STATE_WILDCARD,"*");

  auto_report_add(r,"Paranoia was not able to retrieve the bus:target:lun "
		  "numbers for %10 cdrom device \"%9\" from the "
		  "kernel; this is likely due to this Linux driver not "
		  "supporting the SCSI_IOCTL_GET_IDLUN ioctl() call.  "
		  "Without this support, Paranoia cannot automap \"%9\" to "
		  "a\nmatching %10 device for use.  Please specify "
		  "the desired generic (/dev/sg*) device explicitly.",
		  "1","*","*","1",P_ERROR_BTL,IFFAMILY_WILDCARD,
		  HARDTYPE_WILDCARD,A_STATE_WILDCARD,"*");
}

char *__pi_platform_devname(int iftype,int hardtype,char *devicename,char *b){
  sprintf(b,"%s",iff_names[iftype]);
  switch(iftype){
  case IFFAMILY_UNKNOWN:
  case IFFAMILY_OTHER:
  case IFFAMILY_PROPSPECIAL:
  case IFFAMILY_SCSISPECIAL:
  case IFFAMILY_IDESPECIAL:
  case IFFAMILY_PARIDESPECIAL:
  case IFFAMILY_PARSCSISPECIAL:
    if(hardtype>HARDTYPE_OTHER){
      strcat(b," ");
      strcat(b,hard_names[hardtype]);
    }
    break;
  default:
    /* Nothing.  There is no second thing. */
  }
  return(b);
}

#endif


