/******************************************************************
 * COMMAND Paranoia IV
 * CopyPolicy: GNU Public License 2 applies
 * Copyright (C) 1998 Monty xiphmont@mit.edu
 *
 * Packet based command set abstraction
 *
 ******************************************************************/

#include <string.h>
#include <errno.h>

#include "trans_paranoia.h"
#include "paranoia_errors.h"
#include "comm_paranoia.h"

extern command_device *cdda_command_open(transport_device *d,
				  void (*callback)(int,int,void*));

command_device *packet_command_open(transport_device *d,int cset,
				    void (*callback)(int,int,void*)){
  command_device temp;
  memset(&temp,0,sizeof(temp));
  temp.dev=d;

  /* first off, do we have a packet based transport device? */
  switch(d->packettype){
  case TRANSSET_SCSI:
  case TRANSSET_ATAPI:
    /* both packet based */
    break;
  default:
    errno=P_ERROR_EWRONGTYPE;
    if(callback)(*callback)(errno,CALLBACK_ARG_COMM,&temp);
    return(NULL);
  }

  /* dispatch based on desired packet command set */
  switch(cset){
  case COMMANDSET_CDDA:
    return(cdda_command_open(d,callback));
    break;
  default:
    errno=P_ERROR_ENOSET;
    if(callback)(*callback)(errno,CALLBACK_ARG_COMM,&temp);
    return(NULL);
  }
}

