/******************************************************************
 * Paranoia IV
 * CopyPolicy: GNU Public License 2 applies
 * Copyright (C) 1999 Monty xiphmont@mit.edu
 *
 * Error numbers for all the different layers.  It made no sense
 * to split them up
 *
 ******************************************************************/

#ifndef _PARAERR_H_
#define _PARAERR_H_

#define P_ERROR_NOERR               0
#define P_ERROR_WILDCARD            1

#define P_ERROR_EACCES           2      /* Permission denied */
#define P_ERROR_ENOMEM           3      /* Out of memory */
#define P_ERROR_EBADNAME         4      /* Bad filename */
#define P_ERROR_ENODEV           5      /* No device support */
#define P_ERROR_EFAULT           6      /* Pathname segfault */
#define P_ERROR_EMFILE           7      /* too many files open */
#define P_ERROR_ENOSYS           8      /* can't use this devtype */
#define P_ERROR_EWRONGTYPE       9      /* Wrong device/interface type */
#define P_ERROR_ENOSET          11      /* No such command set for dev */
#define P_ERROR_ETIME           12      /* Timeout */
#define P_ERROR_EIO             13      /* I/O error */
#define P_ERROR_CHECKSENSE      14      /* Packet command error */
#define P_ERROR_EPACKETBIG      15      /* Packet request too big */
#define P_ERROR_ENOTCONFIG      16      /* Support not configured */
#define P_ERROR_ENOTDEVICE      17      /* Not a device file */
#define P_ERROR_BTL             18      /* could not find bus,target,lun */
#define P_ERROR_NOMAPFILES      19      /* could not stat files for mapping */
#define P_ERROR_NOMAPACCESS     20      /* no permissin to access map files */
#define P_ERROR_NOMAPFULL       21      /* checked all files; no map found */
#define P_ERROR_NOMAPSOME       22      /* no map, but could not check all */
#define P_ERROR_EINQ            23      /* could not perform INQUIRY */
#define P_ERROR_ENOWRITE        24      /* device couldn't be opened for R/W */
#define P_ERROR_ENXIO           25      /* No such device */
#define P_ERROR_INTERNAL        26      /* internal logic failure */ 

#define P_WARN_NOPROC         1024      /* Proc filesystem missing */

#define P_INFO_LOADMOD       65536      /* trying kernel module load */
#define P_INFO_LOADEDMOD     65537      /* loaded module */
#define P_INFO_XLOADEDMOD    65538      /* probably failed to load module */
#define P_INFO_DEVTRYMAP     65539      /* look for appropriate device match */
#define P_INFO_DEVGOTMAP     65540      /* got appropriate device match */

extern int errno_translate(int); /* implemented in the trans lib */

#endif
