/******************************************************************
 * REPORT infrastructure
 * CopyPolicy: GNU Public License 2 applies
 * Copyright (C) 1998 Monty xiphmont@mit.edu
 ******************************************************************/

#ifndef report_para_h
#define report_para_h

#include <stdarg.h>

typedef struct report_entry{
  char **matchpoints;
  char *message;

}  report_entry;

typedef struct report_base{
  int axes;
  int praxes;
  report_entry *list;
  int entries;
} report_base;

extern report_base *report_create(int axes,int praxes);
extern void report_add(report_base *b, ...);
extern void report_delete(report_base *b, ...);
extern char *report_lookup(report_base *b, ...);

#endif

