/******************************************************************
 * REPORT infrastructure
 * CopyPolicy: GNU Public License 2 applies
 * Copyright (C) 1998 Monty xiphmont@mit.edu
 ******************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include "paranoia_report.h"

/* simpleminded, straightforward, reliable, brute-force.  Exceptions
   are, after all, exceptional cases.  Optimization here wouldn't be
   well directed.  Coming up with an interface more convenient to user
   apps would. */

report_base *report_create(int axes,int praxes){
  report_base *r=calloc(1,sizeof(report_base));

  r->axes=axes;
  r->praxes=praxes;
  return(r);
}

/* Search alg is simple.  Search left to right down the state list, at
   each point taking exact matches over a '*' match; eliminate those in
   the list not matched.  After the search is done, take the latest
   addition from the set that was not eliminated. */

void report_add(report_base *b, ...){
  va_list vl;
  int i;
  report_entry *e;
  
  b->list=realloc(b->list,(b->entries+1)*sizeof(report_entry));
  e=b->list+b->entries;
  e->matchpoints=malloc(sizeof(char *)*b->axes);

  va_start(vl,b);
  e->message=strdup(va_arg(vl,char *));
  for(i=0;i<b->axes;i++){
    e->matchpoints[i]=strdup(va_arg(vl,char *));
  }
  va_end(vl);
  b->entries++;
}

/* Search alg is simple.  Search left to right down the state list, at
   each point taking exact matches over a '*' match; eliminate those in
   the list not matched.  After the search is done, take the latest
   addition from the set that was not eliminated. */

/* brute force */

report_entry *single_search(report_base *b,char **parsed,int degree,
			    report_entry **inlist,char *match,int loose){
  int count=0;
  report_entry *swork[b->entries+1],*sret,**inptr=inlist;
  if(degree>=b->axes)
    return(inlist[0]);

  /* list the matches */
  while(*inptr){
    if(!strcmp((*inptr)->matchpoints[degree],match)){
      swork[count++]=*inptr;
    }
    inptr++;
  }
  swork[count]=NULL;
  if(count==0)return(NULL); /* not strictly necessary, but there's no
			       need to thrash the whole tree */

  /* recurse with the matches */
  sret=single_search(b,parsed,degree+1,swork,parsed[degree+1],loose);
  if(sret==NULL && loose)
    sret=single_search(b,parsed,degree+1,swork,"*",loose);
  return(sret);
}

report_entry *report_search(report_base *b, char **parsed,int loose){  
  int i;
  report_entry *swork[b->entries+1],*sret;
  for(i=0;i<b->entries;i++)
    swork[i]=b->list+b->entries-i-1;
  swork[i]=NULL;

  sret=single_search(b,parsed,0,swork,parsed[0],loose);
  if(sret==NULL && loose)
    sret=single_search(b,parsed,0,swork,"*",loose);

  return(sret);
}

char *report_lookup(report_base *b, ...){
  report_entry *e;
  char *parsed[b->praxes];
  va_list args;
  int i,size=0,count=0;
  char *ret=NULL;

  va_start(args,b);
  for(i=0;i<b->praxes;i++)
    parsed[i]=va_arg(args,char *);
  va_end(args);

  e=report_search(b,parsed,1);
  if(e==NULL)return(NULL);

  /* Ugh.  What size will we be?  asprintf isn't universally available */
  {
    char *ptr=e->message;
    while(*ptr!=0){
      if(*ptr=='%' && isdigit(*(ptr+1))){
	int num;
	ptr++;
	num=atoi(ptr);
	while(isdigit(*++ptr));
	if(num>=0 && num<b->praxes)
	  size+=strlen(parsed[num]);
      }else{
	size++;
	ptr++;
      }
    }
    size++;
  }
  ret=calloc(size+1,sizeof(char));
  {
    char *ptr=e->message;
    while(*ptr!=0){
      if(*ptr=='%' && isdigit(*(ptr+1))){
	int num;
	ptr++;
	num=atoi(ptr);
	while(isdigit(*++ptr));
	if(num>=0 && num<b->praxes){
	  strcat(ret,parsed[num]);
	  count+=strlen(parsed[num]);
	}
      }else{
	ret[count++]=*(ptr++);
      }
    }
    count++;
  }
  if(count!=size){
    fprintf(stderr,"Internal error preparing report!\n\n");
    exit(0);
  }
  return(ret);
}

/* again, a naieve implementation */

void snip_entry(report_base *b,report_entry *e){
  int pos=e-b->list;
  int am=b->entries-pos-1;
  if(am)memmove(e,e+1,sizeof(report_entry)*am);
  b->entries--;
}

void report_delete(report_base *b, ...){
  char *parsed[b->praxes];
  va_list args;
  int i;
  report_entry *match;

  va_start(args,b);
  for(i=0;i<b->praxes;i++)
    parsed[i]=va_arg(args,char *);
  va_end(args);

  while((match=report_search(b,parsed,0)))
    snip_entry(b,match);
}
