/******************************************************************
 * TRANSPORT Paranoia IV
 * CopyPolicy: GNU Public License 2 applies
 * Copyright (C) 1999 Monty xiphmont@mit.edu
 * 
 * System -> lib stable errno translation
 *
 ******************************************************************/

#include <errno.h>
#include "paranoia_errors.h"

int errno_translate(int err){
  switch(err){
  case EACCES: case EPERM:
    return(P_ERROR_EACCES);
  case ENOMEM:
    return(P_ERROR_ENOMEM);
  case EBADF:case EROFS:
    return(P_ERROR_ENOWRITE);
  case ELOOP: case ENOTDIR: case ENOENT: case ENAMETOOLONG:
    return(P_ERROR_EBADNAME);
  case EFAULT:
    return(P_ERROR_EFAULT);
  case EMFILE: case ENFILE:
    return(P_ERROR_EMFILE);
  case ETIME:
    return(P_ERROR_ETIME);
  case EIO:
    return(P_ERROR_EIO);
  case ENODEV:case ENOSYS:
    return(P_ERROR_ENODEV);
  case ENXIO:
    return(P_ERROR_ENXIO);
  default:
    return(P_ERROR_INTERNAL);
  }
}

