/******************************************************************
 * TRANSPORT Paranoia IV
 * CopyPolicy: GNU Public License 2 applies
 * Copyright (C) 1999 Monty xiphmont@mit.edu
 * 
 * Generic open for random ioctl() based devices
 *
 ******************************************************************/

#include <stdlib.h>
#include <unistd.h>
#include "trans_paranoia.h"
#include "paranoia_errors.h"
#include <errno.h>

#ifdef LINUX
#include <string.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <linux/hdreg.h>

#ifdef SBPCD_H
#include <linux/sbpcd.h>
#endif

#ifdef UCDROM_H
#include <linux/ucdrom.h>
#endif

#include <linux/cdrom.h>
#include <linux/major.h>

/* platform specific information to bury in transport_device */
typedef struct linuxioctl_device{
  int sectors_at_a_time;
  int has_cdda_ioctl;
} linuxioctl_device;

static int linuxioctl_close(transport_device *d,
			    void (*callback)(int,int,void*)){

}

static int linuxioctl_reset(transport_device *d,
			    void (*callback)(int,int,void*)){
  return(0);
}

static int linuxioctl_special(transport_device *d,int commandset,
			    void (*callback)(int,int,void*)){

}


/* Need to tag the device type; IDE drives are tagged with
   IFFAMILY_IDESPECIAL and a model.  Proprietary drives are just
   tagged IFFAMILY_PROPSPECIAL and the IF subtype is in the model
   string */

transport_device *linuxioctl_open(int fd, void (*callback)(int,int,void *)){
  transport_device *d=calloc(1,sizeof(transport_device));
  linuxioctl_device *l=calloc(1,sizeof(linuxioctl_device));
  d->platform_dev=l;

  d->close=&linuxioctl_close;
  d->reset=&linuxioctl_reset;
  d->command=NULL;
  d->special=&linuxioctl_special;

  d->fd=fd;
  d->packettype=PACKET_COOKED;

  /* Do a little more probing.  because this is handling IDE + a bunch
     of legacy proprietary interfaces, it's a little sillier than for
     SCSI. */

  /* The HDIO_GET_IDENTITY ioctl() will both certify us as IDE and
     also get the vendor info.  If we're not IDE, fall back to a
     simple switch on major to determine device types, as the legacy
     devides are unlikely to move around. */

  /* Work around the fact that the struct grew without warning in
     2.1/2.0.34 */
  
  { 
    struct cdrom_volctrl volctl;
    struct hd_driveid *id=malloc(512); /* the size in 2.0.34 */
    char *ret;

    if (!(ioctl(fd, HDIO_GET_IDENTITY, id))) {
      /* IDE/ATAPI */
      d->iffamily=IFFAMILY_IDESPECIAL;
      if(id->model==0 || id->model[0]==0)
	d->devmodel=strdup("unidentified IDE");
      else
	d->devmodel=strdup(id->model);

      /* Are we a CDROM or something else? */
      if (ioctl(fd, CDROMVOLREAD, &volctl)) {
	/* not a CDROM; add other pings later when more device types
           are added to the ioctl driver */
	d->hardtype=HARDTYPE_OTHER;
      }else{
	/* CDROM */
	d->hardtype=HARDTYPE_CDROM;
	d->max_response_bytes=8*2352; /* 8 sectors */
	l->has_cdda_ioctl=1;
      }
    }else{
      /* 'random weirdshit' */

      struct stat st;

      d->iffamily=IFFAMILY_PROPSPECIAL;
      fstat(fd,&st);
      switch((int)(st.st_rdev>>8)){
      case CDU31A_CDROM_MAJOR:
	/* major indicates this is a cdrom; no ping necessary. */
	d->hardtype=HARDTYPE_CDROM;
	d->devmodel=strdup("Sony CDU31A or compatible");
	l->has_cdda_ioctl=1;

	/* set read buffer size. don't make the buffer too big; this
	   sucker don't preempt */

	/**** callback ****/
	{
	  int nsectors=32;
	  while(1){

	    /* this ioctl returns zero on error; exactly wrong, but that's
	       what it does. */

	    if(ioctl(fd, CDROMAUDIOBUFSIZ, nsectors)==0){
	      nsectors>>=1;
	      if(nsectors==0){
		/**** callback: trouble setting sector size ****/
		d->max_response_bytes=8*2352; /* 8 sectors */
		break; /* Oh, well.  Try to read anyway.*/
	      }
	    }else{
	      /**** callback ****/
	      d->max_response_bytes=nsectors*2352; /* 8 sectors */
	      break;
	    }
	  }
	}
	break;
      case CDU535_CDROM_MAJOR:
	/* major indicates this is a cdrom; no ping necessary. */
	d->hardtype=HARDTYPE_CDROM;
	d->devmodel=strdup("Sony CDU535 or compatible");
	l->has_cdda_ioctl=1;
	d->max_response_bytes=40*2352; /* 40 sectors */
	break;
      case MATSUSHITA_CDROM_MAJOR:
      case MATSUSHITA_CDROM2_MAJOR:
      case MATSUSHITA_CDROM3_MAJOR:
      case MATSUSHITA_CDROM4_MAJOR:
	/* major indicates this is a cdrom; no ping necessary. */
	d->hardtype=HARDTYPE_CDROM;
	d->devmodel=strdup("IDE-like Matsushita/Panasonic CR-5xx or "
			   "compatible");
	d->max_response_bytes=40*2352; /* 40 sectors */
	l->has_cdda_ioctl=1;
	break;
      case SANYO_CDROM_MAJOR:
	d->hardtype=HARDTYPE_CDROM;
	d->devmodel=strdup("Sanyo proprietary or compatible");
	break;
      case MITSUMI_CDROM_MAJOR:
      case MITSUMI_X_CDROM_MAJOR:
	d->hardtype=HARDTYPE_CDROM;
	d->devmodel=strdup("Mitsumi proprietary or compatible");
	break;
      case OPTICS_CDROM_MAJOR:
	d->hardtype=HARDTYPE_CDROM;
	d->devmodel=strdup("Optics Dolphin or compatible");
	break;
      case AZTECH_CDROM_MAJOR:
	d->hardtype=HARDTYPE_CDROM;
	d->devmodel=strdup("Aztech proprietary or compatible");;
	break;
      case GOLDSTAR_CDROM_MAJOR:
	d->hardtype=HARDTYPE_CDROM;
	d->devmodel=strdup("Goldstar proprietary");
	break;
      case CM206_CDROM_MAJOR:
	d->hardtype=HARDTYPE_CDROM;
	d->devmodel=strdup("Philips/LMS CM206 proprietary");
	break;
      default:
	/* What the hell is this? */
	d->iffamily=IFFAMILY_UNKNOWN;
	d->hardtype=HARDTYPE_UNKNOWN;
	break;
      }
    }
  }

  /* ready.  I guess */

  return(d);
}

#else

transport_device *linuxioctl_open(int fd, void (*callback)(int,int,void *)){
  transport_device temp;
  temp.packettype=PACKET_COOKED;
  temp.iffamily=IFFAMILY_IDESPECIAL;
  temp.hardtype=HARDTYPE_UNKNOWN;

  errno=P_ERROR_ENOTCONFIG;
  if(callback)callback(errno,CALLBACK_ARG_TRANS,d);
  return(NULL);

#endif









