/******************************************************************
 * TRANSPORT Paranoia IV
 * CopyPolicy: GNU Public License 2 applies
 * Copyright (C) 1999 Monty xiphmont@mit.edu
 * 
 * Linux Generic SCSI transport layer
 *
 ******************************************************************/

#include <stdlib.h>
#include <unistd.h>
#include "trans_paranoia.h"
#include "paranoia_errors.h"
#include "trans_common.h"
#include <errno.h>

#if defined(LINUX) && defined (SG_H)

#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>

#include <scsi/sg.h>
#include <scsi/scsi.h>
#define SG_OFF sizeof(struct sg_header)
#define MAX_BIG_BUFF_SIZE 65536

/* platform specific information to bury in transport_device */
typedef struct linuxsg_device{
  sigset_t sigset_toblock;
  char *sg;
  char *sg_buffer;
} linuxsg_device;

/* Linux specific detect and workarounds **********************/

/* Not like old paranoia; we know from the kernel source that ENOMEM
   only happens if the request is too big.  The request can even be
   gibberish (so long as it's safe for the device if it *does* go
   through ;-) Try an inquiry with an oversize transfer buffer. */

static void find_bloody_big_buff_size(transport_device *d,void
				      (*callback)(int,int,void *)){




}

static void clear_garbage(transport_device *d){
  linuxsg_device *l=d->platform_dev;
  fd_set fdset;
  struct timeval tv;
  struct sg_header *sg_hd=(struct sg_header *)l->sg;
  int flag=0;

  /* clear out any possibly preexisting garbage */
  FD_ZERO(&fdset);
  FD_SET(d->fd,&fdset);
  tv.tv_sec=0;
  tv.tv_usec=0;

  /* I like select */
  while(select(d->fd+1,&fdset,NULL,NULL,&tv)==1){
    
    sg_hd->twelve_byte = 0;
    sg_hd->result = 0;
    sg_hd->reply_len = SG_OFF;
    read(d->fd, sg_hd, 1);

    /* reset for select */
    FD_ZERO(&fdset);
    FD_SET(d->fd,&fdset);
    tv.tv_sec=0;
    tv.tv_usec=0;
    flag=1;
  }
}

static int linuxsg_close(transport_device *d,void (*callback)(int,int,void*)){

}

static int linuxsg_reset(transport_device *d,void (*callback)(int,int,void*)){

  /* really ought to close the fd and reopen to force some cleanup */

  errno=P_ERROR_ENOSYS;
  if(callback)callback(errno,CALLBACK_ARG_TRANS,d);
  return(-1);
}

/* process a complete scsi command. */
/* lock the fd before submitting; current SG can do bad things to
   silmultaneous requests on the same device */

/* 9.4 had a sighandling bug; signals are not unblocked if select()
   for read() errors out */

static int linuxsg_command(transport_device *d,packet_command *c,
			   void (*callback)(int,int,void *)){

  return(0);
}

/* Used by the generic atapi check code */

static int linuxsg_check_atapi(transport_device *d,
			       void (*callback)(int,int,void *)){

}  

transport_device *linuxsg_open(int fd, void (*callback)(int,int,void *)){
  transport_device *d=calloc(1,sizeof(transport_device));
  linuxsg_device *l=calloc(1,sizeof(linuxsg_device));
  d->platform_dev=l;

  d->close=&linuxsg_close;
  d->reset=&linuxsg_reset;
  d->command=&linuxsg_command;

  /* build signal set to block for during generic scsi; we *really* don't
     want to die between the SCSI write and reading the result. */

  sigemptyset (&(l->sigset_toblock));
  sigaddset (&(l->sigset_toblock), SIGINT);
  sigaddset (&(l->sigset_toblock), SIGALRM);
  sigaddset (&(l->sigset_toblock), SIGHUP);
  sigaddset (&(l->sigset_toblock), SIGQUIT);
  sigaddset (&(l->sigset_toblock), SIGTERM);
  sigaddset (&(l->sigset_toblock), SIGSTOP);
  sigaddset (&(l->sigset_toblock), SIGUSR1);
  sigaddset (&(l->sigset_toblock), SIGUSR2);
  sigaddset (&(l->sigset_toblock), SIGPIPE);
  sigaddset (&(l->sigset_toblock), SIGPROF);

  /* malloc our big buffer for scsi commands */
  l->sg=malloc(MAX_BIG_BUFF_SIZE);
  l->sg_buffer=l->sg+SG_OFF;

  d->fd=fd;
  d->packettype=PACKET_SCSI;
  if(__pi_scsi_check_mmc(d,callback))
    d->packet_flags|=SCSIFLAG_MMC;
  if(linuxsg_check_atapi(d,callback))
    d->packet_flags|=SCSIFLAG_ATAPI;
  else
    d->packet_flags|=SCSIFLAG_SCSI;


  {
    char t[36],*p;
    p = __pi_scsi_inquiry(d,t,36); /* minimal inquiry command
					    that can make do with very
					    little setup */
    if (!p) {
      errno=P_ERROR_EINQ;
      if(callback)callback(errno,CALLBACK_ARG_TRANS,d);
      d->fd=-1; /* the fd isn't ours to close yet */
      linuxsg_close(d,callback);
      return(NULL);
    }

    switch((int)*p){
    case TYPE_WORM:
    case TYPE_ROM:
      d->hardtype=HARDTYPE_CDROM;
      break;
    case TYPE_DISK:
      d->hardtype=HARDTYPE_DISK;
      break;
    case TYPE_PROCESSOR: /* HP scanners :-P */
    case TYPE_SCANNER:
      d->hardtype=HARDTYPE_SCANNER;
      break;
    case TYPE_TAPE:
      d->hardtype=HARDTYPE_TAPE;
      break;
    default:
      d->hardtype=HARDTYPE_UNKNOWN;
      break;
    }

    d->devmodel=calloc(36,sizeof(char));
    d->inq=calloc(36,sizeof(char));
    memcpy(d->inq,p,36);
    d->inqbytes=36;
    __pi_strscat(d->devmodel,p+8,8);
    __pi_strscat(d->devmodel,p+16,16);
    __pi_strscat(d->devmodel,p+32,4);

  }

  find_bloody_big_buff_size(d,callback);

  return(d);
}


#else

transport_device *linuxsg_open(int fd, void (*callback)(int,int,void *)){
  transport_device temp;

  temp.fd=fd;
  temp.iftype=DEVTYPE_LINUX_SG;

  temp.packettype=PACKET_SCSI;
  temp.iffamily=IFFAMILY_SCSIGENERIC;
  temp.hardtype=HARDTYPE_UNKNOWN;

  errno=P_ERROR_ENOTCONFIG;
  if(callback)callback(errno,CALLBACK_ARG_TRANS,temp);
  return(NULL);
}

#endif









