/******************************************************************
 * TRANS Paranoia IV
 * CopyPolicy: GNU Public License 2 applies
 * (C) 1998 Monty xiphmont@mit.edu
 * 
 * TRANS sample callback building block
 *
 ******************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "trans_paranoia.h"
#include "paranoia_errors.h" /* error numbers for all paranoia */

/* # report axes: ERR, WARN, INFO, LONG, erno, packettype, iffam, hardtype
          addend for SCSI: key, asc, asq, devmodel */

report_base *trans_callback_reportdb(void){
  report_base *r=report_create(9,11);


  return(r);
}

void trans_callback_setup(transport_device *t){
  if(!t->reportdb)t->reportdb=trans_callback_reportdb();
}

/* right now this is a bit SCSI specific; we'll need to rearrange
   slightly when we go postal */

char *trans_report_lookup(transport_device *t,packet_command *p,
			  int ERR, int WARN, int INFO, int LONG, int err){

  char *errS;
  char *warnS;
  char *infoS;
  char *longS;
  char errnoS[80];

  char ptS[80];
  char itS[80];
  char dtS[80];
  char *devmodel=t->devmodel;
  if(!devmodel)devmodel="";

  errS=(ERR?"1":"0");
  warnS=(WARN?"1":"0");
  infoS=(INFO?"1":"0");
  longS=(LONG?"1":"0");
  sprintf(errnoS,"%d",err);

  sprintf(ptS,"%d",t->packettype);
  sprintf(itS,"%d",t->iffamily);
  sprintf(dtS,"%d",t->hardtype);

  if(p && t->packettype==PACKET_SCSI){
    scsi_packet_command *s=&p->scsi;
    if(s->sensedata[0]==0x70){
      char keyS[80];
      char ascS[80];
      char asqS[80];
      
      sprintf(keyS,"%x",(int)(s->sensedata[2]&0xf));
      sprintf(ascS,"%x",(int)(s->sensedata[12]));
      sprintf(asqS,"%x",(int)(s->sensedata[13]));
      
      return(report_lookup(t->reportdb,errS,warnS,infoS,longS,errnoS,
			   ptS,itS,dtS,keyS,ascS,asqS,devmodel));
    }
  }

  return(report_lookup(t->reportdb,errS,warnS,infoS,longS,errnoS,
		       ptS,itS,dtS,"0","0","0",devmodel));

}

char *trans_callback(int err,int argtype,void *arg,int verbosity){

  transport_device *t=NULL;
  packet_command *p=NULL;

  switch(argtype){
  case CALLBACK_ARG_TRANS:
    t=(transport_device *)arg;
    break;
  case CALLBACK_ARG_SCSI_PACKET:
    p=(packet_command *)arg;
    t=p->scsi.t;
    break;
  default:
    return(NULL);
  }

  /* if we don't have an associated report database, construct it now! */
  if(!t->reportdb)trans_callback_setup(t);

  return(trans_report_lookup(t,p,verbosity&CV_ERROR,verbosity&CV_WARN,
			    verbosity&CV_INFO,verbosity&CV_LONG,err));
}













