#include <endian.h>

/* I wonder how many alignment issues this is gonna trip in the
   future...  it shouldn't trip any...  I guess we'll find out :) */

static inline int bigendianp(void){
  int test=1;
  char *hack=(char *)(&test);
  if(hack[0])return(0);
  return(1);
}

static inline size16 swap16(size16 x){
  return((((unsigned size16)x & 0x00ffU) <<  8) | 
	 (((unsigned size16)x & 0xff00U) >>  8));
}

#if BYTE_ORDER == LITTLE_ENDIAN

static inline size16 be16_to_cpu(size16 x){
  return(swap16(x));
}

static inline size16 le16_to_cpu(size16 x){
  return(x);
}

#else

static inline size16 be16_to_cpu(size16 x){
  return(x);
}

static inline size16 le16_to_cpu(size16 x){
  return(swap16(x));
}


#endif

static inline size16 cpu_to_be16(size16 x){
  return(be16_to_cpu(x));
}

static inline size16 cpu_to_le16(size16 x){
  return(le16_to_cpu(x));
}

