/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.dist.GapDistribution;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.symbol.Alphabet;

public final class MagicalState
extends SimpleEmissionState {
    private static final Map stateCache = new HashMap();
    private static final Map symbolCache = new HashMap();

    public static MagicalState getMagicalState(Alphabet alphabet, int heads) {
        AlphaHeads ah = new AlphaHeads(alphabet, heads);
        MagicalState ms = (MagicalState)stateCache.get(ah);
        if (ms == null) {
            ms = new MagicalState(alphabet, heads);
            stateCache.put(ah, ms);
        }
        return ms;
    }

    private MagicalState(Alphabet alpha, int heads) {
        super("!-" + heads, Annotation.EMPTY_ANNOTATION, new int[heads], new GapDistribution(alpha));
        int[] advance = this.getAdvance();
        int i = 0;
        while (i < heads) {
            advance[i] = 1;
            ++i;
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new PlaceHolder(this.getDistribution().getAlphabet(), this.getAdvance().length);
    }

    private static class PlaceHolder
    implements Serializable {
        private Alphabet alpha;
        private int heads;

        public PlaceHolder(Alphabet alpha, int heads) {
            this.alpha = alpha;
            this.heads = heads;
        }

        public Object readResolve() throws ObjectStreamException {
            return MagicalState.getMagicalState(this.alpha, this.heads);
        }
    }

    private static class AlphaHeads {
        public Alphabet alpha;
        public int heads;

        public AlphaHeads(Alphabet alpha, int heads) {
            this.alpha = alpha;
            this.heads = heads;
        }

        public boolean equals(Object o) {
            AlphaHeads ah = (AlphaHeads)o;
            return this.alpha == ah.alpha && this.heads == ah.heads;
        }

        public int hashCode() {
            return this.alpha.hashCode() ^ this.heads;
        }
    }
}

