/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SequenceViewerListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionSupport;
import org.biojava.bio.gui.sequence.SequenceViewerSupport;
import org.biojava.bio.gui.sequence.SubSequenceRenderContext;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class SequencePoster
extends JComponent
implements SwingConstants,
SequenceRenderContext,
Changeable {
    public static final ChangeType RENDERER = new ChangeType("The renderer for this SequencePoster has changed", "org.biojava.bio.gui.sequence.SequencePoster", "RENDERER", SequenceRenderContext.LAYOUT);
    private Sequence sequence;
    private int direction = 0;
    private double scale = 12.0;
    private int lines = 1;
    private int spacer = 0;
    private SequenceRenderContext.Border leadingBorder;
    private SequenceRenderContext.Border trailingBorder;
    private SequenceRenderer renderer;
    private double[] offsets;
    private int realLines;
    private double alongDim = 0.0;
    private double acrossDim = 0.0;
    private int symbolsPerLine = 0;
    private RendererMonitor theMonitor;
    private transient ChangeSupport changeSupport = null;
    private SequenceViewerSupport svSupport = new SequenceViewerSupport();
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent me) {
            if (!SequencePoster.this.isActive()) {
                return;
            }
            int[] lineExtent = SequencePoster.this.calcLineExtent(me);
            me.translatePoint(-lineExtent[2], -lineExtent[3]);
            SequenceViewerEvent sve = SequencePoster.this.renderer.processMouseEvent(new SubSequenceRenderContext(SequencePoster.this, null, null, new RangeLocation(lineExtent[0], lineExtent[1])), me, new ArrayList());
            me.translatePoint(lineExtent[2], lineExtent[3]);
            SequencePoster.this.svSupport.fireMouseClicked(sve);
        }

        public void mousePressed(MouseEvent me) {
            if (!SequencePoster.this.isActive()) {
                return;
            }
            int[] lineExtent = SequencePoster.this.calcLineExtent(me);
            me.translatePoint(-lineExtent[2], -lineExtent[3]);
            SequenceViewerEvent sve = SequencePoster.this.renderer.processMouseEvent(new SubSequenceRenderContext(SequencePoster.this, null, null, new RangeLocation(lineExtent[0], lineExtent[1])), me, new ArrayList());
            me.translatePoint(lineExtent[2], lineExtent[3]);
            SequencePoster.this.svSupport.fireMousePressed(sve);
        }

        public void mouseReleased(MouseEvent me) {
            if (!SequencePoster.this.isActive()) {
                return;
            }
            int[] lineExtent = SequencePoster.this.calcLineExtent(me);
            me.translatePoint(-lineExtent[2], -lineExtent[3]);
            SequenceViewerEvent sve = SequencePoster.this.renderer.processMouseEvent(new SubSequenceRenderContext(SequencePoster.this, null, null, new RangeLocation(lineExtent[0], lineExtent[1])), me, new ArrayList());
            me.translatePoint(lineExtent[2], lineExtent[3]);
            SequencePoster.this.svSupport.fireMouseReleased(sve);
        }
    };
    private SequenceViewerMotionSupport svmSupport = new SequenceViewerMotionSupport();
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent me) {
            if (!SequencePoster.this.isActive()) {
                return;
            }
            int[] lineExtent = SequencePoster.this.calcLineExtent(me);
            me.translatePoint(-lineExtent[2], -lineExtent[3]);
            SequenceViewerEvent sve = SequencePoster.this.renderer.processMouseEvent(new SubSequenceRenderContext(SequencePoster.this, null, null, new RangeLocation(lineExtent[0], lineExtent[1])), me, new ArrayList());
            me.translatePoint(lineExtent[2], lineExtent[3]);
            SequencePoster.this.svmSupport.fireMouseDragged(sve);
        }

        public void mouseMoved(MouseEvent me) {
            if (!SequencePoster.this.isActive()) {
                return;
            }
            int[] lineExtent = SequencePoster.this.calcLineExtent(me);
            me.translatePoint(-lineExtent[2], -lineExtent[3]);
            SequenceViewerEvent sve = SequencePoster.this.renderer.processMouseEvent(new SubSequenceRenderContext(SequencePoster.this, null, null, new RangeLocation(lineExtent[0], lineExtent[1])), me, new ArrayList());
            me.translatePoint(lineExtent[2], lineExtent[3]);
            SequencePoster.this.svmSupport.fireMouseMoved(sve);
        }
    };
    private ChangeListener layoutListener = new ChangeAdapter(){

        public void postChange(ChangeEvent ce) {
            SequencePoster.this.resizeAndValidate();
        }
    };
    private ChangeListener repaintListener = new ChangeAdapter(){

        public void postChange(ChangeEvent ce) {
            SequencePoster.this.repaint();
        }
    };

    public void addSequenceViewerListener(SequenceViewerListener svl) {
        this.svSupport.addSequenceViewerListener(svl);
    }

    public void removeSequenceViewerListener(SequenceViewerListener svl) {
        this.svSupport.removeSequenceViewerListener(svl);
    }

    public void addSequenceViewerMotionListener(SequenceViewerMotionListener svml) {
        this.svmSupport.addSequenceViewerMotionListener(svml);
    }

    public void removeSequenceViewerMotionListener(SequenceViewerMotionListener svml) {
        this.svmSupport.removeSequenceViewerMotionListener(svml);
    }

    protected boolean hasChangeListeners() {
        return this.changeSupport != null;
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        return this.changeSupport;
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        ChangeSupport cs;
        ChangeSupport changeSupport = cs = this.getChangeSupport(ct);
        synchronized (changeSupport) {
            cs.addChangeListener(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        ChangeSupport cs;
        ChangeSupport changeSupport = cs = this.getChangeSupport(ct);
        synchronized (changeSupport) {
            cs.removeChangeListener(cl);
        }
    }

    public SequencePoster() {
        this.theMonitor = new RendererMonitor();
        this.leadingBorder = new SequenceRenderContext.Border();
        this.trailingBorder = new SequenceRenderContext.Border();
        if (this.getFont() == null) {
            this.setFont(new Font("Times New Roman", 0, 12));
        }
        this.addPropertyChangeListener(this.theMonitor);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    public void setSequence(Sequence s) {
        Sequence oldSequence = this.sequence;
        if (oldSequence != null) {
            oldSequence.removeChangeListener(this.layoutListener);
        }
        this.sequence = s;
        this.sequence.addChangeListener(this.layoutListener);
        this.resizeAndValidate();
        this.firePropertyChange("sequence", oldSequence, s);
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public SymbolList getSymbols() {
        return this.sequence;
    }

    public FeatureHolder getFeatures() {
        return this.sequence;
    }

    public RangeLocation getRange() {
        return new RangeLocation(1, this.sequence.length());
    }

    public void setDirection(int dir) throws IllegalArgumentException {
        if (dir != 0 && dir != 1) {
            throw new IllegalArgumentException("Direction must be either HORIZONTAL or VERTICAL");
        }
        int oldDirection = this.direction;
        this.direction = dir;
        this.resizeAndValidate();
        this.firePropertyChange("direction", oldDirection, this.direction);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setSpacer(int spacer) {
        int oldSpacer = this.spacer;
        this.spacer = spacer;
        this.resizeAndValidate();
        this.firePropertyChange("spacer", oldSpacer, spacer);
    }

    public int getSpacer() {
        return this.spacer;
    }

    public void setScale(double scale) {
        double oldScale = this.scale;
        this.scale = scale;
        this.resizeAndValidate();
        this.firePropertyChange("scale", oldScale, scale);
    }

    public double getScale() {
        return this.scale;
    }

    public void setLines(int lines) {
        int oldLines = this.lines;
        this.lines = lines;
        this.resizeAndValidate();
        this.firePropertyChange("lines", oldLines, lines);
    }

    public int getLines() {
        return this.lines;
    }

    public SequenceRenderContext.Border getLeadingBorder() {
        return this.leadingBorder;
    }

    public SequenceRenderContext.Border getTrailingBorder() {
        return this.trailingBorder;
    }

    public void paintComponent(Graphics g) {
        double maxPos;
        double minPos;
        if (!this.isActive()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D currentClip = g2.getClip().getBounds2D();
        if (this.direction == 0) {
            minPos = currentClip.getMinY();
            maxPos = currentClip.getMaxY();
        } else {
            minPos = currentClip.getMinX();
            maxPos = currentClip.getMaxX();
        }
        int minOffset = Arrays.binarySearch(this.offsets, minPos);
        if (minOffset < 0) {
            minOffset = -minOffset - 1;
        }
        double minCoord = minOffset == 0 ? 0.0 : this.offsets[minOffset - 1];
        int minP = 1 + (int)((double)minOffset * (double)this.symbolsPerLine);
        Rectangle2D.Double clip = new Rectangle2D.Double();
        if (this.direction == 0) {
            clip.width = this.alongDim;
            clip.height = this.acrossDim;
            g2.translate(this.leadingBorder.getSize() - this.alongDim * (double)minOffset, minCoord);
        } else {
            clip.width = this.acrossDim;
            clip.height = this.alongDim;
            g2.translate(minCoord, this.leadingBorder.getSize() - this.alongDim * (double)minOffset);
        }
        int min = minP;
        int l = minOffset;
        while (l < this.realLines) {
            int max = Math.min(min + this.symbolsPerLine - 1, this.sequence.length());
            RangeLocation pos = new RangeLocation(min, max);
            if (this.direction == 0) {
                clip.x = (double)l * this.alongDim;
                clip.y = 0.0;
            } else {
                clip.x = 0.0;
                clip.y = (double)l * this.alongDim;
            }
            double depth = this.offsets[l] - (double)this.spacer;
            if (l != 0) {
                depth -= this.offsets[l - 1];
            }
            if (this.direction == 0) {
                clip.height = depth;
            } else {
                clip.width = depth;
            }
            Shape oldClip = g2.getClip();
            g2.clip(clip);
            this.renderer.paint(g2, this);
            g2.setClip(oldClip);
            if (this.direction == 0) {
                g2.translate(-this.alongDim, (double)this.spacer + depth);
            } else {
                g2.translate((double)this.spacer + depth, -this.alongDim);
            }
            if ((min += this.symbolsPerLine) > this.sequence.length() || this.offsets[l] > maxPos) break;
            ++l;
        }
    }

    public void setRenderer(SequenceRenderer r) throws ChangeVetoException {
        if (this.hasChangeListeners()) {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RENDERER, r, this.renderer);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RENDERER);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this._setRenderer(r);
                cs.firePostChangeEvent(ce);
            }
        } else {
            this._setRenderer(r);
        }
        this.resizeAndValidate();
    }

    protected void _setRenderer(SequenceRenderer r) {
        Changeable c;
        if (this.renderer != null && this.renderer instanceof Changeable) {
            c = (Changeable)((Object)this.renderer);
            c.removeChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            c.removeChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
        this.renderer = r;
        if (r != null && r instanceof Changeable) {
            c = (Changeable)((Object)r);
            c.addChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            c.addChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
    }

    public double sequenceToGraphics(int seqPos) {
        return (double)(seqPos - 1) * this.scale;
    }

    public int graphicsToSequence(double gPos) {
        return (int)(gPos / this.scale) + 1;
    }

    public int graphicsToSequence(Point point) {
        if (this.direction == 0) {
            return this.graphicsToSequence(point.getX());
        }
        return this.graphicsToSequence(point.getY());
    }

    public void resizeAndValidate() {
        Dimension d = null;
        if (!this.isActive()) {
            System.out.println("No sequence");
            this.alongDim = 0.0;
            double acrossDim = 0.0;
            this.realLines = 0;
            this.leadingBorder.setSize(0.0);
            this.trailingBorder.setSize(0.0);
            d = new Dimension(0, 0);
        } else {
            System.out.println("Fitting to sequence");
            Dimension parentSize = this.getParent() != null ? this.getParent().getSize() : new Dimension(500, 400);
            int width = this.direction == 0 ? parentSize.width : parentSize.height;
            System.out.println("Initial width: " + width);
            this.alongDim = this.scale * (double)this.sequence.length();
            System.out.println("alongDim (pixles needed for sequence only): " + this.alongDim);
            double acrossDim = 0.0;
            RangeLocation range = new RangeLocation(1, this.sequence.length());
            double insetBefore = this.renderer.getMinimumLeader(this);
            double insetAfter = this.renderer.getMinimumTrailer(this);
            this.leadingBorder.setSize(insetBefore);
            this.trailingBorder.setSize(insetAfter);
            double insets = insetBefore + insetAfter;
            if (this.lines > 0) {
                this.realLines = this.lines;
                width = (int)Math.ceil(insets + this.alongDim / (double)this.lines);
            } else {
                double dWidth = width;
                dWidth -= insets;
                this.realLines = (int)Math.ceil(this.alongDim / (double)width);
                width = (int)Math.ceil(insets + this.alongDim / (double)this.realLines);
            }
            acrossDim = 0.0;
            this.symbolsPerLine = (int)Math.ceil((double)width / this.scale);
            if (this.symbolsPerLine < 1) {
                throw new Error("Pants");
            }
            int min = 1;
            this.offsets = new double[this.realLines];
            int li = 0;
            while (min <= this.sequence.length()) {
                int max = min + this.symbolsPerLine - 1;
                RangeLocation pos = new RangeLocation(min, max);
                double depth = this.renderer.getDepth(this);
                this.offsets[li] = acrossDim += depth + (double)this.spacer;
                min = max + 1;
                ++li;
            }
            this.alongDim = (double)this.symbolsPerLine * this.scale;
            d = this.direction == 0 ? new Dimension((int)Math.ceil(this.alongDim + insetBefore + insetAfter), (int)acrossDim) : new Dimension((int)(acrossDim += (double)(this.spacer * (this.realLines - 1))), (int)Math.ceil(this.alongDim + insetBefore + insetAfter));
        }
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.revalidate();
    }

    protected int[] calcLineExtent(MouseEvent me) {
        int ydiff;
        int xdiff;
        int pos = this.direction == 0 ? me.getY() : me.getX();
        int minOffset = Arrays.binarySearch(this.offsets, (double)pos);
        if (minOffset < 0) {
            minOffset = -minOffset - 1;
        }
        int min = 1 + (int)((double)minOffset * (double)this.symbolsPerLine);
        int max = min + this.symbolsPerLine - 1;
        double minPos = minOffset > 0 ? this.offsets[minOffset - 1] : 0.0;
        double ad = this.alongDim * (double)minOffset;
        if (this.direction == 0) {
            xdiff = (int)(-ad);
            ydiff = (int)minPos;
        } else {
            xdiff = (int)minPos;
            ydiff = (int)(-ad);
        }
        return new int[]{min, max, xdiff, ydiff};
    }

    protected boolean isActive() {
        return this.sequence != null && this.renderer != null;
    }

    public class Border
    implements Serializable,
    SwingConstants {
        protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private double size = 0.0;
        private int alignment = 0;

        public double getSize() {
            return this.size;
        }

        private void setSize(double size) {
            this.size = size;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public void setAlignment(int alignment) throws IllegalArgumentException {
            if (alignment != 10 && alignment != 11 && alignment != 0) {
                throw new IllegalArgumentException("Alignment must be one of the constants LEADING, TRAILING or CENTER");
            }
            int old = this.alignment;
            this.alignment = alignment;
            this.pcs.firePropertyChange("alignment", old, alignment);
        }

        private Border() {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    private class RendererMonitor
    implements PropertyChangeListener {
        private RendererMonitor() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            SequencePoster.this.repaint();
        }
    }
}

