/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DAS;
import org.biojava.bio.program.das.DASCapabilities;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.FeatureFetcher;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;

class FeatureRequestManager {
    private Set openTickets = new HashSet();
    private DASSequenceDB seqDB;

    FeatureRequestManager(DASSequenceDB seqDB) {
        this.seqDB = seqDB;
    }

    public Ticket requestFeatures(URL ds, String id, SeqIOListener l) {
        return this.requestFeatures(ds, id, l, null, null);
    }

    public Ticket requestFeatures(URL ds, String id, SeqIOListener l, String type, String category) {
        Ticket t = new Ticket(ds, id, l, type, category);
        this.openTickets.add(t);
        return t;
    }

    private static boolean stringCompare(String a, String b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    private FeatureFetcher makeFeatureFetcher(URL dataSourceURL, String triggerType, String triggerCategory) throws BioException {
        FeatureFetcher ffetcher = new FeatureFetcher(dataSourceURL, triggerType, triggerCategory);
        try {
            boolean doXMLRequest = DASCapabilities.checkCapable(new URL(dataSourceURL, "../"), "dasExtendedRequest", "features");
            ffetcher.setUseXMLFetch(doXMLRequest);
        }
        catch (MalformedURLException ex) {
            throw new BioException(ex);
        }
        return ffetcher;
    }

    private synchronized void fetch(Ticket trigger) throws ParseException, BioException {
        this.seqDB.ensureFeaturesCacheCapacity(this.openTickets.size() * 3);
        String triggerType = trigger.getType();
        String triggerCategory = trigger.getCategory();
        HashMap<URL, FeatureFetcher> fetchers = new HashMap<URL, FeatureFetcher>();
        Iterator i = this.openTickets.iterator();
        while (i.hasNext()) {
            Ticket t = (Ticket)i.next();
            if (!FeatureRequestManager.stringCompare(triggerType, t.getType()) || !FeatureRequestManager.stringCompare(triggerCategory, t.getCategory())) continue;
            URL dataSourceURL = t.getDataSource();
            FeatureFetcher ffetcher = (FeatureFetcher)fetchers.get(dataSourceURL);
            if (ffetcher == null) {
                ffetcher = this.makeFeatureFetcher(dataSourceURL, triggerType, triggerCategory);
                fetchers.put(dataSourceURL, ffetcher);
            }
            ffetcher.addTicket(t);
        }
        if (fetchers.size() < 1) {
            System.err.println("*** Hmmm, don't actually seem to be fetching anything...");
            return;
        }
        if (DAS.getThreadFetches() && fetchers.size() > 1) {
            FetchMonitor monitor = new FetchMonitor();
            Iterator i2 = fetchers.values().iterator();
            while (i2.hasNext()) {
                monitor.addJob((FeatureFetcher)i2.next());
            }
            List okay = monitor.doFetches();
            Iterator i3 = okay.iterator();
            while (i3.hasNext()) {
                FeatureFetcher ffetcher = (FeatureFetcher)i3.next();
                this.openTickets.removeAll(ffetcher.getDoneTickets());
            }
        } else {
            Iterator i4 = fetchers.values().iterator();
            while (i4.hasNext()) {
                FeatureFetcher ffetcher = (FeatureFetcher)i4.next();
                ffetcher.runFetch();
                this.openTickets.removeAll(ffetcher.getDoneTickets());
            }
        }
    }

    public class Ticket {
        private boolean _isFired = false;
        private String id;
        private String type;
        private String category;
        private SeqIOListener outputListener;
        private URL dataSource;

        public Ticket(URL dataSource, String id, SeqIOListener listener, String type, String category) {
            this.dataSource = dataSource;
            this.id = id;
            this.outputListener = listener;
            this.type = type;
            this.category = category;
        }

        private URL getDataSource() {
            return this.dataSource;
        }

        String getID() {
            return this.id;
        }

        SeqIOListener getOutputListener() {
            return this.outputListener;
        }

        private String getType() {
            return this.type;
        }

        private String getCategory() {
            return this.category;
        }

        void setAsFetched() {
            this._isFired = true;
            this.id = null;
            this.outputListener = null;
        }

        public void doFetch() throws ParseException, BioException {
            if (!this._isFired) {
                FeatureRequestManager.this.fetch(this);
            }
        }

        public boolean isFetched() {
            return this._isFired;
        }
    }

    private class FetchJob
    extends Thread {
        private FeatureFetcher fetcher;
        private FetchMonitor monitor;

        FetchJob(FeatureFetcher fetcher, FetchMonitor monitor) {
            this.fetcher = fetcher;
            this.monitor = monitor;
        }

        public FeatureFetcher getFetcher() {
            return this.fetcher;
        }

        public void run() {
            try {
                this.fetcher.runFetch();
                this.monitor.jobSucceeded(this);
            }
            catch (Exception ex) {
                this.monitor.jobFailed(this, ex);
            }
        }
    }

    private class FetchMonitor {
        private Set pending = new HashSet();
        private List successes = new ArrayList();
        private FetchJob failedJob;
        private Exception failure;

        private FetchMonitor() {
        }

        public void addJob(FeatureFetcher ff) {
            this.pending.add(new FetchJob(ff, this));
        }

        public void jobSucceeded(FetchJob j) {
            List list = this.successes;
            synchronized (list) {
                this.successes.add(j.getFetcher());
            }
            Set set = this.pending;
            synchronized (set) {
                this.pending.remove(j);
                if (this.pending.size() == 0) {
                    this.pending.notifyAll();
                }
            }
        }

        public void jobFailed(FetchJob j, Exception ex) {
            if (this.failedJob == null) {
                this.failedJob = j;
                this.failure = ex;
            }
            Set set = this.pending;
            synchronized (set) {
                this.pending.remove(j);
                if (this.pending.size() == 0) {
                    this.pending.notifyAll();
                }
            }
        }

        public List doFetches() throws BioException {
            Set set = this.pending;
            synchronized (set) {
                Iterator i = this.pending.iterator();
                while (i.hasNext()) {
                    FetchJob job = (FetchJob)i.next();
                    job.start();
                }
                try {
                    this.pending.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.pending.size() != 0) {
                throw new BioError("Assertion failed: threads going screwy");
            }
            if (this.failedJob != null) {
                throw new BioException(this.failure, "Failure while fetching features from " + this.failedJob.getFetcher().getDataSourceURL());
            }
            return this.successes;
        }
    }
}

