/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.BlastLikeVersionSupport;
import org.xml.sax.SAXException;

final class HSPSummaryHelper {
    private HSPSummaryHelper() {
    }

    public static void parse(String poLine, HashMap poMap, BlastLikeVersionSupport poVersion) throws SAXException {
        int iProgram = poVersion.getProgram();
        if (iProgram == 1 || iProgram == 3 || iProgram == 2 || iProgram == 4 || iProgram == 5) {
            HSPSummaryHelper.parseNCBIBlast(poLine, poMap, poVersion);
            return;
        }
        if (iProgram == 11 || iProgram == 13 || iProgram == 12 || iProgram == 14 || iProgram == 15) {
            HSPSummaryHelper.parseWUBlast(poLine, poMap, poVersion);
            return;
        }
        if (iProgram == 32) {
            HSPSummaryHelper.parseNCBIBlast(poLine, poMap, poVersion);
            return;
        }
        throw new SAXException("Failed attempting to parse an HSP Summary because program ".concat(poVersion.getProgramString()).concat(" is not supported."));
    }

    static void parseNCBIBlast(String poLine, HashMap poMap, BlastLikeVersionSupport poVersion) {
        StringBuffer oTmpBuffer = new StringBuffer();
        poMap.clear();
        StringTokenizer oSt = new StringTokenizer(poLine.toLowerCase(), ",");
        block0: while (oSt.hasMoreTokens()) {
            String oToken = oSt.nextToken().trim();
            StringTokenizer oSt2 = new StringTokenizer(oToken);
            while (oSt2.hasMoreTokens()) {
                char[] aoTmpArray;
                StringTokenizer oTmp;
                String oValue;
                String oKey;
                String oToken2 = oSt2.nextToken().trim();
                if (oToken2.equals("score")) {
                    oKey = "score";
                    oSt2.nextToken();
                    oValue = oSt2.nextToken();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (oToken2.startsWith("expect")) {
                    oKey = "expectValue";
                    oSt2.nextToken();
                    oValue = oSt2.nextToken();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (oToken2.equals("identities")) {
                    oSt2.nextToken();
                    oTmp = new StringTokenizer(oSt2.nextToken(), "/");
                    oKey = "numberOfIdentities";
                    oValue = oTmp.nextToken();
                    poMap.put(oKey, oValue);
                    oKey = "alignmentSize";
                    oValue = oTmp.nextToken();
                    poMap.put(oKey, oValue);
                    oTmp = new StringTokenizer(oSt2.nextToken(), "(%)");
                    oKey = "percentageIdentity";
                    oValue = oTmp.nextToken();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (oToken2.equals("positives")) {
                    oSt2.nextToken();
                    oTmp = new StringTokenizer(oSt2.nextToken(), "/");
                    oKey = "numberOfPositives";
                    oValue = oTmp.nextToken();
                    poMap.put(oKey, oValue);
                    oTmp = new StringTokenizer(oSt2.nextToken(), "(%)");
                    oKey = "percentagePositives";
                    oValue = oTmp.nextToken();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (oToken2.equals("strand")) {
                    oSt2.nextToken();
                    oKey = "queryStrand";
                    oValue = oSt2.nextToken();
                    poMap.put(oKey, oValue);
                    oSt2.nextToken();
                    oKey = "hitStrand";
                    oValue = oSt2.nextToken();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (!oToken2.equals("frame")) continue;
                oSt2.nextToken();
                if (poVersion.getProgram() == 3) {
                    oKey = "queryFrame";
                    aoTmpArray = oSt2.nextToken().toCharArray();
                    oTmpBuffer.setLength(0);
                    if (aoTmpArray[0] == '+') {
                        oTmpBuffer.append("plus");
                    } else {
                        oTmpBuffer.append("minus");
                    }
                    oTmpBuffer.append(aoTmpArray[1]);
                    oValue = oTmpBuffer.toString();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (poVersion.getProgram() == 4) {
                    oKey = "hitFrame";
                    aoTmpArray = oSt2.nextToken().toCharArray();
                    oTmpBuffer.setLength(0);
                    if (aoTmpArray[0] == '+') {
                        oTmpBuffer.append("plus");
                    } else {
                        oTmpBuffer.append("minus");
                    }
                    oTmpBuffer.append(aoTmpArray[1]);
                    oValue = oTmpBuffer.toString();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (poVersion.getProgram() != 5) continue;
                oKey = "queryFrame";
                aoTmpArray = oSt2.nextToken().toCharArray();
                oTmpBuffer.setLength(0);
                if (aoTmpArray[0] == '+') {
                    oTmpBuffer.append("plus");
                } else {
                    oTmpBuffer.append("minus");
                }
                oTmpBuffer.append(aoTmpArray[1]);
                oValue = oTmpBuffer.toString();
                poMap.put(oKey, oValue);
                oSt2.nextToken();
                oKey = "hitFrame";
                aoTmpArray = oSt2.nextToken().toCharArray();
                oTmpBuffer.setLength(0);
                if (aoTmpArray[0] == '+') {
                    oTmpBuffer.append("plus");
                } else {
                    oTmpBuffer.append("minus");
                }
                oTmpBuffer.append(aoTmpArray[1]);
                oValue = oTmpBuffer.toString();
                poMap.put(oKey, oValue);
                continue block0;
            }
        }
    }

    static void parseWUBlast(String poLine, HashMap poMap, BlastLikeVersionSupport poVersion) {
        StringBuffer oTmpBuffer = new StringBuffer();
        poMap.clear();
        StringTokenizer oSt = new StringTokenizer(poLine.toLowerCase(), ",");
        block0: while (oSt.hasMoreTokens()) {
            String oToken = oSt.nextToken().trim();
            StringTokenizer oSt2 = new StringTokenizer(oToken);
            while (oSt2.hasMoreTokens()) {
                char[] aoTmpArray;
                StringTokenizer oTmp;
                String oValue;
                String oKey;
                String oToken2 = oSt2.nextToken().trim();
                if (oToken2.equals("score")) {
                    oKey = "score";
                    oSt2.nextToken();
                    oValue = oSt2.nextToken();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (oToken2.startsWith("expect")) {
                    oKey = "expectValue";
                    oSt2.nextToken();
                    oValue = oSt2.nextToken();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (oToken2.equals("identities")) {
                    oSt2.nextToken();
                    oTmp = new StringTokenizer(oSt2.nextToken(), "/");
                    oKey = "numberOfIdentities";
                    oValue = oTmp.nextToken();
                    poMap.put(oKey, oValue);
                    oKey = "alignmentSize";
                    oValue = oTmp.nextToken();
                    poMap.put(oKey, oValue);
                    oTmp = new StringTokenizer(oSt2.nextToken(), "(%)");
                    oKey = "percentageIdentity";
                    oValue = oTmp.nextToken();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (oToken2.equals("positives")) {
                    oSt2.nextToken();
                    oTmp = new StringTokenizer(oSt2.nextToken(), "/");
                    oKey = "numberOfPositives";
                    oValue = oTmp.nextToken();
                    poMap.put(oKey, oValue);
                    oTmp = new StringTokenizer(oSt2.nextToken(), "(%)");
                    oKey = "percentagePositives";
                    oValue = oTmp.nextToken();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (oToken2.equals("strand")) {
                    oSt2.nextToken();
                    oKey = "queryStrand";
                    oValue = oSt2.nextToken();
                    poMap.put(oKey, oValue);
                    oSt2.nextToken();
                    oKey = "hitStrand";
                    oValue = oSt2.nextToken();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (!oToken2.equals("frame")) continue;
                oSt2.nextToken();
                if (poVersion.getProgram() == 13) {
                    oKey = "queryFrame";
                    aoTmpArray = oSt2.nextToken().toCharArray();
                    oTmpBuffer.setLength(0);
                    if (aoTmpArray[0] == '+') {
                        oTmpBuffer.append("plus");
                    } else {
                        oTmpBuffer.append("minus");
                    }
                    oTmpBuffer.append(aoTmpArray[1]);
                    oValue = oTmpBuffer.toString();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (poVersion.getProgram() == 14) {
                    oKey = "hitFrame";
                    aoTmpArray = oSt2.nextToken().toCharArray();
                    oTmpBuffer.setLength(0);
                    if (aoTmpArray[0] == '+') {
                        oTmpBuffer.append("plus");
                    } else {
                        oTmpBuffer.append("minus");
                    }
                    oTmpBuffer.append(aoTmpArray[1]);
                    oValue = oTmpBuffer.toString();
                    poMap.put(oKey, oValue);
                    continue block0;
                }
                if (poVersion.getProgram() != 15) continue;
                oKey = "queryFrame";
                aoTmpArray = oSt2.nextToken().toCharArray();
                oTmpBuffer.setLength(0);
                if (aoTmpArray[0] == '+') {
                    oTmpBuffer.append("plus");
                } else {
                    oTmpBuffer.append("minus");
                }
                oTmpBuffer.append(aoTmpArray[1]);
                oValue = oTmpBuffer.toString();
                poMap.put(oKey, oValue);
                oSt2.nextToken();
                oKey = "hitFrame";
                aoTmpArray = oSt2.nextToken().toCharArray();
                oTmpBuffer.setLength(0);
                if (aoTmpArray[0] == '+') {
                    oTmpBuffer.append("plus");
                } else {
                    oTmpBuffer.append("minus");
                }
                oTmpBuffer.append(aoTmpArray[1]);
                oValue = oTmpBuffer.toString();
                poMap.put(oKey, oValue);
                continue block0;
            }
        }
    }
}

