/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.search.SearchBuilder;
import org.biojava.bio.program.search.SearchParser;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.search.SequenceDBSearchHit;
import org.biojava.bio.search.SequenceDBSearchResult;
import org.biojava.bio.search.SequenceDBSearchSubHit;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBInstallation;
import org.biojava.bio.seq.io.TokenParser;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public class FastaSearchBuilder
implements SearchBuilder {
    private SearchParser parser;
    private boolean moreSearchesAvailable = false;
    private SequenceDBInstallation subjectDBs;
    private SequenceDB subjectDB;
    private SequenceDB querySeqHolder;
    private SymbolList querySeq;
    private Annotation hitAnnotation;
    private Annotation resultAnnotation;
    private Map resultPreAnnotation;
    private Map searchParameters;
    private Map hitData;
    private StringBuffer querySeqBuf;
    private StringBuffer subjectSeqBuf;
    private StringBuffer querySeqPrep;
    private StringBuffer subjectSeqPrep;
    private TokenParser tokenParser;
    private ArrayList searchHits = new ArrayList();

    public FastaSearchBuilder(SequenceDBInstallation subjectDBs, SequenceDB querySeqHolder) {
        this.subjectDBs = subjectDBs;
        this.querySeqHolder = querySeqHolder;
        this.querySeqBuf = new StringBuffer();
        this.subjectSeqBuf = new StringBuffer();
        this.querySeqPrep = new StringBuffer();
        this.subjectSeqPrep = new StringBuffer();
        this.searchParameters = new HashMap();
    }

    public SeqSimilaritySearchResult makeSearchResult() throws BioException {
        return new SequenceDBSearchResult(this.subjectDB, this.searchParameters, this.querySeq, this.resultAnnotation, this.searchHits);
    }

    public void setQuerySeq(String querySeqId) throws BioException {
        try {
            this.querySeq = this.querySeqHolder.getSequence(querySeqId);
        }
        catch (BioException be) {
            throw new BioException(be, "Failed to retrieve query sequence from holder using ID: " + querySeqId);
        }
    }

    public void setSubjectDB(String subjectDBName) throws BioException {
        this.subjectDB = this.subjectDBs.getSequenceDB(subjectDBName);
        if (this.subjectDB == null) {
            throw new BioException("Failed to retrieve database from installation using ID: " + subjectDBName);
        }
    }

    public boolean getMoreSearches() {
        return this.moreSearchesAvailable;
    }

    public void setMoreSearches(boolean value) {
        this.moreSearchesAvailable = value;
    }

    public void startSearch() {
    }

    public void endSearch() {
    }

    public void startHeader() {
        this.resultPreAnnotation = new HashMap();
        this.searchParameters = new HashMap();
    }

    public void addSearchProperty(Object key, Object value) {
        this.resultPreAnnotation.put(key, value);
    }

    public void endHeader() {
        this.resultAnnotation = this.makeAnnotation(this.resultPreAnnotation);
    }

    public void startHit() {
        this.hitData = new HashMap();
    }

    public void addHitProperty(Object key, Object value) {
        this.hitData.put(key, value);
    }

    public void endHit() {
    }

    public void startSubHit() {
    }

    public void addSubHitProperty(Object key, Object value) {
        this.hitData.put(key, value);
    }

    public void endSubHit() {
        this.hitAnnotation = this.makeAnnotation(this.hitData);
        try {
            SeqSimilaritySearchHit hit = this.makeHit(this.hitData, this.hitAnnotation);
            this.searchHits.add(hit);
        }
        catch (BioException be) {
            be.printStackTrace();
        }
    }

    private SeqSimilaritySearchHit makeHit(Map hitData, Annotation hitAnnotation) throws BioException {
        String seqType = (String)hitData.get("query_sq_type");
        String subjectSeqID = (String)hitData.get("id");
        double score = Double.parseDouble((String)hitData.get("fa_z-score"));
        double eValue = Double.parseDouble((String)hitData.get("fa_expect"));
        double pValue = Double.parseDouble((String)hitData.get("fa_expect"));
        int queryStart = Integer.parseInt((String)hitData.get("query_al_start"));
        int queryEnd = Integer.parseInt((String)hitData.get("query_al_stop"));
        int queryDispStart = Integer.parseInt((String)hitData.get("query_al_display_start"));
        String querySeqTokens = (String)hitData.get("querySeqTokens");
        StrandedFeature.Strand querySeqStrand = StrandedFeature.POSITIVE;
        int subjectStart = Integer.parseInt((String)hitData.get("subject_al_start"));
        int subjectEnd = Integer.parseInt((String)hitData.get("subject_al_stop"));
        int subjectDispStart = Integer.parseInt((String)hitData.get("subject_al_display_start"));
        String subjectSeqTokens = (String)hitData.get("subjectSeqTokens");
        StrandedFeature.Strand subjectSeqStrand = ((String)hitData.get("fa_frame")).equals("f") ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
        FiniteAlphabet alpha = seqType.equals("DNA") ? DNATools.getDNA() : ProteinTools.getTAlphabet();
        if (this.tokenParser == null) {
            this.tokenParser = new TokenParser(alpha);
        }
        ArrayList<SequenceDBSearchSubHit> subHits = new ArrayList<SequenceDBSearchSubHit>();
        this.querySeqBuf.setLength(0);
        this.querySeqPrep.setLength(0);
        this.querySeqBuf.append(querySeqTokens);
        this.subjectSeqBuf.setLength(0);
        this.subjectSeqPrep.setLength(0);
        this.subjectSeqBuf.append(subjectSeqTokens);
        try {
            this.querySeqPrep.append(this.prepSeqTokens(this.querySeqBuf, queryStart, queryEnd, queryDispStart));
            this.subjectSeqPrep.append(this.prepSeqTokens(this.subjectSeqBuf, subjectStart, subjectEnd, subjectDispStart));
            Alignment alignment = this.makeAlignment(subjectSeqID, this.querySeqPrep, this.subjectSeqPrep, this.tokenParser);
            SequenceDBSearchSubHit subHit = new SequenceDBSearchSubHit(score, eValue, pValue, queryStart, queryEnd, querySeqStrand, subjectStart, subjectEnd, subjectSeqStrand, alignment);
            subHits.add(subHit);
        }
        catch (IllegalSymbolException ise) {
            throw new BioException("Failed to create alignment for hit to " + subjectSeqID + ": " + ise.getMessage());
        }
        return new SequenceDBSearchHit(score, eValue, pValue, queryStart, queryEnd, querySeqStrand, subjectStart, subjectEnd, subjectSeqStrand, subjectSeqID, hitAnnotation, subHits);
    }

    private Annotation makeAnnotation(Map preAnnotation) {
        SmallAnnotation annotation = new SmallAnnotation();
        Set annotationKeySet = preAnnotation.keySet();
        Iterator ksi = annotationKeySet.iterator();
        while (ksi.hasNext()) {
            Object annotationKey = ksi.next();
            Object annotationValue = preAnnotation.get(annotationKey);
            try {
                annotation.setProperty(annotationKey, annotationValue);
            }
            catch (ChangeVetoException cve) {
                System.err.println("Failed to add mapping to Annotation:");
                cve.printStackTrace();
            }
        }
        return annotation;
    }

    private Alignment makeAlignment(String subjectSeqID, StringBuffer querySeqBuf, StringBuffer subjectSeqBuf, TokenParser tokenParser) throws IllegalSymbolException {
        HashMap<String, SymbolList> labelMap = new HashMap<String, SymbolList>();
        labelMap.put("Query", tokenParser.parse(querySeqBuf.toString()));
        labelMap.put(subjectSeqID, tokenParser.parse(querySeqBuf.toString()));
        return new SimpleAlignment(labelMap);
    }

    private String prepSeqTokens(StringBuffer seqTokens, int alStart, int alStop, int alDispStart) {
        while (seqTokens.charAt(0) == '-') {
            seqTokens.deleteCharAt(0);
        }
        int gapCount = 0;
        int i = 0;
        while (i < seqTokens.length()) {
            if (seqTokens.charAt(i) == '-') {
                ++gapCount;
            }
            ++i;
        }
        return seqTokens.substring(alStart - alDispStart, alStop - alDispStart + gapCount + 1);
    }
}

