/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.util.HashMap;
import java.util.Iterator;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolPropertyTable;

public class MassCalc {
    public static final double Cmono = 12.0;
    public static final double Hmono = 1.007825;
    public static final double Nmono = 14.003074;
    public static final double Omono = 15.9949146;
    public static final double Cavg = 12.011;
    public static final double Havg = 1.00794;
    public static final double Navg = 14.00674;
    public static final double Oavg = 15.9994;
    private HashMap mSymbolPropertyHash;
    private double hydroxMass = 0.0;

    public MassCalc(String isotopicType) {
        if (isotopicType.equals("avgMass")) {
            this.hydroxMass = 17.00734;
        } else if (isotopicType.equals("monoMass")) {
            this.hydroxMass = 17.002739599999998;
        }
        this.mSymbolPropertyHash = new HashMap();
        SymbolPropertyTable symbolPropertyTable = ProteinTools.getSymbolPropertyTable(isotopicType);
        Iterator symbolList = ProteinTools.getAlphabet().iterator();
        while (symbolList.hasNext()) {
            Symbol sym = (Symbol)symbolList.next();
            try {
                System.out.println(sym.getName() + ":" + sym.getToken());
                try {
                    Double value = new Double(symbolPropertyTable.getDoubleValue(sym));
                    this.mSymbolPropertyHash.put(sym, value);
                }
                catch (NullPointerException npe) {}
            }
            catch (IllegalSymbolException ise) {
                ise.printStackTrace(System.err);
            }
        }
    }

    public void setSymbolModification(char symbolToken, double mass) throws IllegalSymbolException {
        Iterator list = ProteinTools.getAlphabet().iterator();
        while (list.hasNext()) {
            Symbol sym = (Symbol)list.next();
            if (sym.getToken() != symbolToken) continue;
            this.mSymbolPropertyHash.put(sym, new Double(mass));
        }
    }

    public void addSymbolModification(Symbol residue, double mass) throws IllegalSymbolException {
    }

    public static final double getMass(SymbolList proteinSeq, String isotopicType, boolean MH_PLUS) {
        if (!proteinSeq.getAlphabet().getName().equals("PROTEIN")) {
            // empty if block
        }
        double pepMass = 0.0;
        SymbolPropertyTable sPT = ProteinTools.getSymbolPropertyTable(isotopicType);
        try {
            Iterator it = proteinSeq.iterator();
            while (it.hasNext()) {
                pepMass += sPT.getDoubleValue((Symbol)it.next());
            }
        }
        catch (IllegalSymbolException ise) {
            ise.printStackTrace();
        }
        double hydroxMass = 0.0;
        if (isotopicType.equals("avgMass")) {
            hydroxMass = 17.00734;
        } else if (isotopicType.equals("monoMass")) {
            hydroxMass = 17.002739599999998;
        }
        if (pepMass != 0.0) {
            pepMass = MH_PLUS ? (pepMass += 3.0 * hydroxMass) : (pepMass += 2.0 * hydroxMass);
        }
        return pepMass;
    }

    public double getMass(SymbolList proteinSeq, boolean MH_PLUS) {
        if (!proteinSeq.getAlphabet().getName().equals("PROTEIN")) {
            // empty if block
        }
        double pepMass = 0.0;
        HashMap symbolPropertyMap = this.getSymbolPropertyMap();
        Iterator it = proteinSeq.iterator();
        while (it.hasNext()) {
            Double mass = (Double)symbolPropertyMap.get((Symbol)it.next());
            pepMass += mass.doubleValue();
        }
        if (pepMass != 0.0) {
            pepMass = MH_PLUS ? (pepMass += 3.0 * this.hydroxMass) : (pepMass += 2.0 * this.hydroxMass);
        }
        return pepMass;
    }

    private HashMap getSymbolPropertyMap() {
        return this.mSymbolPropertyHash;
    }
}

