/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.OptimizableFilter;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.utils.ChangeVetoException;

public class FilterUtils {
    public static boolean areProperSubset(FeatureFilter sub, FeatureFilter sup) {
        if (sub.equals(sup)) {
            return true;
        }
        if (sub instanceof OptimizableFilter) {
            return ((OptimizableFilter)sub).isProperSubset(sup);
        }
        return false;
    }

    public static boolean areDisjoint(FeatureFilter a, FeatureFilter b) {
        return FilterUtils.areDisjointOneWay(a, b) || FilterUtils.areDisjointOneWay(b, a);
    }

    private static boolean areDisjointOneWay(FeatureFilter a, FeatureFilter b) {
        if (a.equals(b)) {
            return false;
        }
        if (a instanceof OptimizableFilter) {
            return ((OptimizableFilter)a).isDisjoint(b);
        }
        return false;
    }

    public static List reversePolish(FeatureFilter filt) {
        ArrayList polish = new ArrayList();
        FilterUtils.reversePolish(polish, filt);
        return polish;
    }

    private static void reversePolish(List polish, FeatureFilter filt) {
        if (filt instanceof FeatureFilter.And) {
            FeatureFilter.And and = (FeatureFilter.And)filt;
            FeatureFilter c1 = and.getChild1();
            FeatureFilter c2 = and.getChild2();
            FilterUtils.reversePolish(polish, c1);
            FilterUtils.reversePolish(polish, c2);
        } else if (filt instanceof FeatureFilter.AndNot) {
            FeatureFilter.AndNot andNot = (FeatureFilter.AndNot)filt;
            FeatureFilter c1 = andNot.getChild1();
            FeatureFilter c2 = andNot.getChild2();
            FilterUtils.reversePolish(polish, c1);
            FilterUtils.reversePolish(polish, c2);
        } else if (filt instanceof FeatureFilter.Or) {
            FeatureFilter.Or or = (FeatureFilter.Or)filt;
            FeatureFilter c1 = or.getChild1();
            FeatureFilter c2 = or.getChild2();
            FilterUtils.reversePolish(polish, c1);
            FilterUtils.reversePolish(polish, c2);
        } else if (filt instanceof FeatureFilter.Not) {
            FeatureFilter.Not not = (FeatureFilter.Not)filt;
            FeatureFilter c = not.getChild();
            FilterUtils.reversePolish(polish, c);
        }
        polish.add(filt);
    }

    public FeatureHolder evaluate(FeatureFilter filt, FeatureHolder fh) throws BioException {
        return this.evaluatePolish(FilterUtils.reversePolish(filt), fh);
    }

    public FeatureHolder evaluatePolish(List polish, FeatureHolder fh) throws BioException {
        try {
            Stack<FeatureHolder> stack = new Stack<FeatureHolder>();
            Iterator i = polish.iterator();
            while (i.hasNext()) {
                Feature f;
                Iterator fi;
                SimpleFeatureHolder a;
                FeatureHolder b;
                FeatureFilter filt = (FeatureFilter)i.next();
                if (filt instanceof FeatureFilter.And) {
                    SimpleFeatureHolder result = new SimpleFeatureHolder();
                    FeatureHolder b2 = (FeatureHolder)stack.pop();
                    FeatureHolder a2 = (FeatureHolder)stack.pop();
                    if (a2.countFeatures() < b2.countFeatures()) {
                        FeatureHolder t = a2;
                        a2 = b2;
                        b2 = t;
                    }
                    Iterator fi2 = b2.features();
                    while (fi2.hasNext()) {
                        Feature f2 = (Feature)fi2.next();
                        if (!a2.containsFeature(f2)) continue;
                        result.addFeature(f2);
                    }
                    stack.push(result);
                    continue;
                }
                if (filt instanceof FeatureFilter.AndNot) {
                    b = (FeatureHolder)stack.pop();
                    a = (SimpleFeatureHolder)stack.peek();
                    fi = b.features();
                    while (fi.hasNext()) {
                        f = (Feature)fi.next();
                        if (!a.containsFeature(f)) continue;
                        a.removeFeature(f);
                    }
                    continue;
                }
                if (filt instanceof FeatureFilter.Or) {
                    b = (FeatureHolder)stack.pop();
                    a = (SimpleFeatureHolder)stack.peek();
                    fi = b.features();
                    while (fi.hasNext()) {
                        f = (Feature)fi.next();
                        if (a.containsFeature(f)) continue;
                        a.addFeature(f);
                    }
                    continue;
                }
                if (filt instanceof FeatureFilter.Not) {
                    throw new IllegalArgumentException("Can't evaluate Not - transform them into AndNot statements");
                }
                if (filt instanceof FilterWrapper) {
                    stack.add(fh.filter(((FilterWrapper)filt).getWrapped(), false));
                    continue;
                }
                stack.add(fh.filter(filt, false));
            }
            return (FeatureHolder)stack.pop();
        }
        catch (ChangeVetoException cve) {
            throw new BioException(cve, "Couldn't evaluate the query");
        }
    }

    private static class FilterWrapper
    implements FeatureFilter {
        private FeatureFilter wrapped;

        public FilterWrapper(FeatureFilter wrapped) {
            this.wrapped = wrapped;
        }

        public FeatureFilter getWrapped() {
            return this.wrapped;
        }

        public boolean accept(Feature f) {
            return this.wrapped.accept(f);
        }
    }
}

