/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.biojava.bio.seq.AbstractFeatureHolder;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.utils.SmallMap;

public class MergeFeatureHolder
extends AbstractFeatureHolder {
    private Map featureHolders;

    public MergeFeatureHolder() {
        this.featureHolders = new SmallMap();
    }

    private MergeFeatureHolder(Map m) {
        this.featureHolders = m;
    }

    public void addFeatureHolder(FeatureHolder fh) {
        this.featureHolders.put(fh, FeatureFilter.all);
    }

    public void addFeatureHolder(FeatureHolder fh, FeatureFilter membershipFilter) {
        this.featureHolders.put(fh, membershipFilter);
    }

    public void removeFeatureHolder(FeatureHolder fh) {
        this.featureHolders.remove(fh);
    }

    public int countFeatures() {
        int fc = 0;
        Iterator i = this.featureHolders.keySet().iterator();
        while (i.hasNext()) {
            fc += ((FeatureHolder)i.next()).countFeatures();
        }
        return fc;
    }

    public boolean containsFeature(Feature f) {
        Iterator i = this.featureHolders.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            FeatureHolder subFH = (FeatureHolder)me.getKey();
            FeatureFilter membership = (FeatureFilter)me.getValue();
            if (!membership.accept(f) || !subFH.containsFeature(f)) continue;
            return true;
        }
        return false;
    }

    public Iterator features() {
        return new MFHIterator();
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        SmallMap results = new SmallMap();
        Iterator fhi = this.featureHolders.entrySet().iterator();
        while (fhi.hasNext()) {
            FeatureHolder filterResult;
            Map.Entry me = fhi.next();
            FeatureHolder fh = (FeatureHolder)me.getKey();
            FeatureFilter mf = (FeatureFilter)me.getValue();
            if (!recurse && FilterUtils.areDisjoint(mf, ff)) continue;
            if (recurse) {
                filterResult = fh.filter(ff, true);
                if (filterResult.countFeatures() <= 0) continue;
                results.put(filterResult, FeatureFilter.all);
                continue;
            }
            if (FilterUtils.areProperSubset(mf, ff)) {
                results.put(fh, mf);
                continue;
            }
            filterResult = fh.filter(ff, false);
            if (filterResult.countFeatures() == 0) continue;
            results.put(filterResult, new FeatureFilter.And(mf, ff));
        }
        if (results.size() == 0) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        if (results.size() == 1) {
            return (FeatureHolder)results.keySet().iterator().next();
        }
        return new MergeFeatureHolder(results);
    }

    public Map getMergeMap() {
        return Collections.unmodifiableMap(this.featureHolders);
    }

    private class MFHIterator
    implements Iterator {
        private Iterator fhIterator;
        private Iterator fIterator;

        public MFHIterator() {
            this.fhIterator = MergeFeatureHolder.this.featureHolders.keySet().iterator();
            this.fIterator = this.fhIterator.hasNext() ? ((FeatureHolder)this.fhIterator.next()).features() : Collections.EMPTY_SET.iterator();
        }

        public boolean hasNext() {
            if (this.fIterator.hasNext()) {
                return true;
            }
            if (this.fhIterator.hasNext()) {
                this.fIterator = ((FeatureHolder)this.fhIterator.next()).features();
                return this.hasNext();
            }
            return false;
        }

        public Object next() {
            if (this.fIterator.hasNext()) {
                return this.fIterator.next();
            }
            if (this.fhIterator.hasNext()) {
                this.fIterator = ((FeatureHolder)this.fhIterator.next()).features();
                return this.next();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

