/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.AbstractFeatureHolder;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.bytecode.ByteCode;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.GeneratedClassLoader;
import org.biojava.utils.bytecode.GeneratedCodeClass;
import org.biojava.utils.bytecode.GeneratedCodeMethod;
import org.biojava.utils.bytecode.Instruction;
import org.biojava.utils.bytecode.InstructionVector;
import org.biojava.utils.bytecode.IntrospectedCodeClass;
import org.biojava.utils.bytecode.LocalVariable;
import org.biojava.utils.bytecode.SimpleCodeMethod;

public class ProjectedFeatureHolder
extends AbstractFeatureHolder {
    private final FeatureHolder wrapped;
    private final FeatureHolder parent;
    private final int translate;
    private FeatureHolder projectedFeatures;
    private boolean oppositeStrand;
    private boolean cachingProjections = true;
    private FeatureFilter filter;
    private ChangeListener underlyingFeaturesChange;
    private static Map _projectionClasses;
    private static int seed;
    private static GeneratedClassLoader loader;
    static /* synthetic */ Class class$org$biojava$bio$seq$Feature;
    static /* synthetic */ Class class$org$biojava$bio$seq$ProjectedFeatureHolder;
    static /* synthetic */ Class class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper;
    static /* synthetic */ Class class$org$biojava$bio$seq$StrandedFeature;
    static /* synthetic */ Class class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper;

    public ProjectedFeatureHolder(FeatureHolder fh, FeatureFilter filter, FeatureHolder parent, int translation, boolean oppositeStrand) {
        this.wrapped = fh;
        this.parent = parent;
        this.translate = translation;
        this.oppositeStrand = oppositeStrand;
        this.filter = filter;
        this.underlyingFeaturesChange = new ChangeListener(){

            public void preChange(ChangeEvent e) throws ChangeVetoException {
                if (ProjectedFeatureHolder.this.changeSupport != null) {
                    ProjectedFeatureHolder.this.changeSupport.firePreChangeEvent(new ChangeEvent(this, FeatureHolder.FEATURES, e.getChange(), e.getPrevious(), e));
                }
            }

            public void postChange(ChangeEvent e) {
                ProjectedFeatureHolder.this.projectedFeatures = null;
                if (ProjectedFeatureHolder.this.changeSupport != null) {
                    ProjectedFeatureHolder.this.changeSupport.firePostChangeEvent(new ChangeEvent(this, FeatureHolder.FEATURES, e.getChange(), e.getPrevious(), e));
                }
            }
        };
        this.wrapped.addChangeListener(this.underlyingFeaturesChange);
    }

    public boolean isCachingProjections() {
        return this.cachingProjections;
    }

    public void setIsCachingProjections(boolean b) {
        this.cachingProjections = b;
        this.projectedFeatures = null;
    }

    public ProjectedFeatureHolder(FeatureHolder fh, FeatureHolder parent, int translation, boolean oppositeStrand) {
        this(fh, null, parent, translation, oppositeStrand);
    }

    protected FeatureHolder getProjectedFeatures() {
        if (this.projectedFeatures != null) {
            return this.projectedFeatures;
        }
        FeatureHolder toProject = this.wrapped;
        if (this.filter != null) {
            toProject = toProject.filter(this.filter, false);
        }
        SimpleFeatureHolder sfh = new SimpleFeatureHolder();
        Iterator i = toProject.features();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            Feature wf = this.projectFeature(f);
            try {
                sfh.addFeature(wf);
            }
            catch (ChangeVetoException cve) {
                throw new BioError(cve, "Assertion failure: Should be able to manipulate this FeatureHolder");
            }
        }
        if (this.cachingProjections) {
            this.projectedFeatures = sfh;
        }
        return sfh;
    }

    protected Feature projectFeature(Feature f) {
        Class<?> featureClass = f.getClass();
        Class<?>[] fcInterfaces = featureClass.getInterfaces();
        Class featureInterface = class$org$biojava$bio$seq$Feature == null ? (class$org$biojava$bio$seq$Feature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.Feature")) : class$org$biojava$bio$seq$Feature;
        int i = fcInterfaces.length - 1;
        while (i >= 0) {
            if ((class$org$biojava$bio$seq$Feature == null ? ProjectedFeatureHolder.class$("org.biojava.bio.seq.Feature") : class$org$biojava$bio$seq$Feature).isAssignableFrom(fcInterfaces[i])) {
                featureInterface = fcInterfaces[i];
                break;
            }
            --i;
        }
        Class projectionClass = ProjectedFeatureHolder.getProjectionClass(featureInterface);
        Class[] sig = new Class[]{featureInterface, class$org$biojava$bio$seq$ProjectedFeatureHolder == null ? (class$org$biojava$bio$seq$ProjectedFeatureHolder = ProjectedFeatureHolder.class$("org.biojava.bio.seq.ProjectedFeatureHolder")) : class$org$biojava$bio$seq$ProjectedFeatureHolder};
        try {
            Constructor ct = projectionClass.getConstructor(sig);
            Object[] args = new Object[]{f, this};
            return (Feature)ct.newInstance(args);
        }
        catch (Exception ex) {
            throw new BioError(ex, "Assertion failed: Couldn't instantiate proxy " + projectionClass.getName());
        }
    }

    public int countFeatures() {
        return this.wrapped.countFeatures();
    }

    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    public boolean containsFeature(Feature f) {
        return this.getProjectedFeatures().containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getProjectedFeatures().filter(ff, recurse);
    }

    private static Class getProjectionClass(Class face) {
        Class projection = (Class)_projectionClasses.get(face);
        if (projection == null) {
            try {
                Class baseClass = class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper == null ? (class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedFeatureWrapper")) : class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper;
                if ((class$org$biojava$bio$seq$StrandedFeature == null ? (class$org$biojava$bio$seq$StrandedFeature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.StrandedFeature")) : class$org$biojava$bio$seq$StrandedFeature).isAssignableFrom(face)) {
                    baseClass = class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper == null ? (class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedStrandedFeatureWrapper")) : class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper;
                }
                StringTokenizer st = new StringTokenizer(face.getName(), ".");
                String faceName = st.nextToken();
                while (st.hasMoreTokens()) {
                    faceName = st.nextToken();
                }
                CodeClass baseClassC = IntrospectedCodeClass.forClass((Class)baseClass);
                CodeClass faceClassC = IntrospectedCodeClass.forClass((Class)face);
                GeneratedCodeClass pclass = new GeneratedCodeClass("org.biojava.bio.seq.impl.Projection_" + faceName + "_" + seed++, baseClassC, new CodeClass[]{faceClassC}, 33);
                ArrayList<CodeClass> baseInitArgsList = new ArrayList<CodeClass>();
                baseInitArgsList.add(baseClass == (class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper == null ? (class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedStrandedFeatureWrapper")) : class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper) ? IntrospectedCodeClass.forClass((Class)(class$org$biojava$bio$seq$StrandedFeature == null ? (class$org$biojava$bio$seq$StrandedFeature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.StrandedFeature")) : class$org$biojava$bio$seq$StrandedFeature)) : IntrospectedCodeClass.forClass((Class)(class$org$biojava$bio$seq$Feature == null ? (class$org$biojava$bio$seq$Feature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.Feature")) : class$org$biojava$bio$seq$Feature)));
                baseInitArgsList.add(IntrospectedCodeClass.forClass((Class)(class$org$biojava$bio$seq$ProjectedFeatureHolder == null ? (class$org$biojava$bio$seq$ProjectedFeatureHolder = ProjectedFeatureHolder.class$("org.biojava.bio.seq.ProjectedFeatureHolder")) : class$org$biojava$bio$seq$ProjectedFeatureHolder)));
                SimpleCodeMethod m_ourBase_init = new SimpleCodeMethod("<init>", baseClassC, CodeUtils.TYPE_VOID, baseInitArgsList, 1);
                SimpleCodeMethod m_ourBase_getViewedFeature = new SimpleCodeMethod("getViewedFeature", baseClassC, IntrospectedCodeClass.forClass((Class)(class$org$biojava$bio$seq$Feature == null ? (class$org$biojava$bio$seq$Feature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.Feature")) : class$org$biojava$bio$seq$Feature)), new ArrayList(), 1);
                GeneratedCodeMethod init = pclass.createMethod("<init>", IntrospectedCodeClass.forClass(Void.TYPE), new CodeClass[]{faceClassC, IntrospectedCodeClass.forClass((Class)(class$org$biojava$bio$seq$ProjectedFeatureHolder == null ? (class$org$biojava$bio$seq$ProjectedFeatureHolder = ProjectedFeatureHolder.class$("org.biojava.bio.seq.ProjectedFeatureHolder")) : class$org$biojava$bio$seq$ProjectedFeatureHolder))}, 1);
                InstructionVector iv = new InstructionVector();
                iv.add((CodeGenerator)ByteCode.make_aload((LocalVariable)init.getThis()));
                iv.add((CodeGenerator)ByteCode.make_aload((LocalVariable)init.getVariable(0)));
                iv.add((CodeGenerator)ByteCode.make_aload((LocalVariable)init.getVariable(1)));
                iv.add((CodeGenerator)ByteCode.make_invokespecial((CodeMethod)m_ourBase_init));
                iv.add((CodeGenerator)ByteCode.make_return());
                pclass.setCodeGenerator((CodeMethod)init, (CodeGenerator)iv);
                Iterator methIt = faceClassC.getMethods().iterator();
                while (methIt.hasNext()) {
                    CodeMethod faceMethod = (CodeMethod)methIt.next();
                    if (baseClassC.getMethodsByName(faceMethod.getName()).size() > 0 || faceMethod.numParameters() > 0) continue;
                    GeneratedCodeMethod proxyMethod = pclass.createMethod(faceMethod.getName(), faceMethod.getReturnType(), CodeUtils.EMPTY_LIST, 1);
                    iv = new InstructionVector();
                    iv.add((CodeGenerator)ByteCode.make_aload((LocalVariable)proxyMethod.getThis()));
                    iv.add((CodeGenerator)ByteCode.make_invokevirtual((CodeMethod)m_ourBase_getViewedFeature));
                    iv.add((CodeGenerator)ByteCode.make_invokeinterface((CodeMethod)faceMethod));
                    Instruction returni = ByteCode.make_areturn();
                    CodeClass rtype = proxyMethod.getReturnType();
                    if (rtype == CodeUtils.TYPE_VOID) {
                        returni = ByteCode.make_return();
                    } else if (rtype == CodeUtils.TYPE_INT || rtype == CodeUtils.TYPE_SHORT || rtype == CodeUtils.TYPE_CHAR || rtype == CodeUtils.TYPE_BYTE) {
                        returni = ByteCode.make_ireturn();
                    } else if (rtype == CodeUtils.TYPE_LONG) {
                        returni = ByteCode.make_lreturn();
                    } else if (rtype == CodeUtils.TYPE_FLOAT) {
                        returni = ByteCode.make_freturn();
                    } else if (rtype == CodeUtils.TYPE_DOUBLE) {
                        returni = ByteCode.make_dreturn();
                    }
                    iv.add((CodeGenerator)returni);
                    pclass.setCodeGenerator((CodeMethod)proxyMethod, (CodeGenerator)iv);
                }
                projection = loader.defineClass(pclass);
                _projectionClasses.put(face, projection);
            }
            catch (CodeException ex) {
                throw new BioError(ex);
            }
        }
        return projection;
    }

    public Location getProjectedLocation(Location oldLoc) {
        if (this.oppositeStrand) {
            if (oldLoc.isContiguous()) {
                return new RangeLocation(this.translate - oldLoc.getMax(), this.translate - oldLoc.getMin());
            }
            Location compound = Location.empty;
            Iterator i = oldLoc.blockIterator();
            while (i.hasNext()) {
                Location oldBlock = (Location)i.next();
                compound = compound.union(new RangeLocation(this.translate - oldBlock.getMax(), this.translate - oldBlock.getMin()));
            }
            return compound;
        }
        return oldLoc.translate(this.translate);
    }

    public int getTranslation() {
        return this.translate;
    }

    public boolean isOppositeStrand() {
        return this.oppositeStrand;
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        seed = 1;
        _projectionClasses = new HashMap();
        _projectionClasses.put(class$org$biojava$bio$seq$Feature == null ? (class$org$biojava$bio$seq$Feature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.Feature")) : class$org$biojava$bio$seq$Feature, class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper == null ? (class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedFeatureWrapper")) : class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper);
        _projectionClasses.put(class$org$biojava$bio$seq$StrandedFeature == null ? (class$org$biojava$bio$seq$StrandedFeature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.StrandedFeature")) : class$org$biojava$bio$seq$StrandedFeature, class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper == null ? (class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedStrandedFeatureWrapper")) : class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper);
        loader = new GeneratedClassLoader((class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper == null ? (class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedFeatureWrapper")) : class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper).getClassLoader());
    }
}

