/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.RNAComplementTranslationTable;
import org.biojava.bio.seq.TranscriptionTable;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleTranslationTable;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.bio.symbol.TranslationTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class RNATools {
    private static final ReversibleTranslationTable complementTable;
    private static final ReversibleTranslationTable transcriptionTable;
    private static final FiniteAlphabet rna;
    private static final Map geneticCodes;
    private static final Symbol a;
    private static final Symbol g;
    private static final Symbol c;
    private static final Symbol u;
    private static Map symbolToComplement;
    static /* synthetic */ Class class$org$biojava$bio$seq$RNATools;

    public static Symbol a() {
        return a;
    }

    public static Symbol g() {
        return g;
    }

    public static Symbol c() {
        return c;
    }

    public static Symbol u() {
        return u;
    }

    public static FiniteAlphabet getRNA() {
        return rna;
    }

    public static SymbolList createRNA(String rna) throws IllegalSymbolException {
        try {
            SymbolParser p = RNATools.getRNA().getParser("token");
            return p.parse(rna);
        }
        catch (BioException se) {
            throw new BioError(se, "Something has gone badly wrong with RNA");
        }
    }

    public static int index(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return 0;
        }
        if (sym == g) {
            return 1;
        }
        if (sym == c) {
            return 2;
        }
        if (sym == u) {
            return 3;
        }
        RNATools.getRNA().validate(sym);
        throw new IllegalSymbolException("Realy confused. Can't find index for " + sym.getName());
    }

    public static Symbol forIndex(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return a;
        }
        if (index == 1) {
            return g;
        }
        if (index == 2) {
            return c;
        }
        if (index == 3) {
            return u;
        }
        throw new IndexOutOfBoundsException("No symbol for index " + index);
    }

    public static Symbol complement(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return u;
        }
        if (sym == g) {
            return c;
        }
        if (sym == c) {
            return g;
        }
        if (sym == u) {
            return a;
        }
        Symbol s = (Symbol)symbolToComplement.get(sym);
        if (s != null) {
            return s;
        }
        RNATools.getRNA().validate(sym);
        throw new BioError("Really confused. Can't find symbol " + sym.getName());
    }

    public static Symbol forSymbol(char token) throws IllegalSymbolException {
        if (token == 'a') {
            return a;
        }
        if (token == 'g') {
            return g;
        }
        if (token == 'c') {
            return c;
        }
        if (token == 'u') {
            return u;
        }
        throw new IllegalSymbolException("Unable to find symbol for token " + token);
    }

    public static SymbolList complement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(list, RNATools.complementTable());
    }

    public static SymbolList reverseComplement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(SymbolListViews.reverse(list), RNATools.complementTable());
    }

    public static SymbolList transcribe(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(list, RNATools.transcriptionTable());
    }

    public static ReversibleTranslationTable complementTable() {
        return complementTable;
    }

    public static ReversibleTranslationTable transcriptionTable() {
        return transcriptionTable;
    }

    public static TranslationTable getGeneticCode(String name) {
        return (TranslationTable)geneticCodes.get(name);
    }

    public static Set getGeneticCodeNames() {
        return geneticCodes.keySet();
    }

    public static SymbolList translate(SymbolList syms) throws IllegalAlphabetException {
        return SymbolListViews.translate(syms, RNATools.getGeneticCode("UNIVERSAL"));
    }

    private static void loadGeneticCodes() {
        try {
            InputStream tablesStream = (class$org$biojava$bio$seq$RNATools == null ? (class$org$biojava$bio$seq$RNATools = RNATools.class$("org.biojava.bio.seq.RNATools")) : class$org$biojava$bio$seq$RNATools).getClassLoader().getResourceAsStream("org/biojava/bio/seq/TranslationTables.xml");
            if (tablesStream == null) {
                throw new BioError("Couldn't locate TranslationTables.xml.");
            }
            InputSource is = new InputSource(tablesStream);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(is);
            NodeList children = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Element child;
                String name;
                Node cnode = children.item(i);
                if (cnode instanceof Element && (name = (child = (Element)cnode).getNodeName()).equals("table")) {
                    String tableName = child.getAttribute("name");
                    String source = child.getAttribute("source");
                    String target = child.getAttribute("target");
                    FiniteAlphabet sourceA = (FiniteAlphabet)AlphabetManager.alphabetForName(source);
                    FiniteAlphabet targetA = (FiniteAlphabet)AlphabetManager.alphabetForName(target);
                    SymbolParser sourceP = sourceA.getParser("name");
                    SymbolParser targetP = targetA.getParser("name");
                    SimpleTranslationTable table = new SimpleTranslationTable(sourceA, targetA);
                    NodeList translates = child.getChildNodes();
                    int j = 0;
                    while (j < translates.getLength()) {
                        Node tn = translates.item(j);
                        if (tn instanceof Element) {
                            Element te = (Element)tn;
                            String from = te.getAttribute("from");
                            String to = te.getAttribute("to");
                            SymbolList fromSymbols = RNATools.createRNA(from);
                            if (fromSymbols.length() != 3) {
                                throw new BioError("`" + from + "' is not a valid codon");
                            }
                            AtomicSymbol fromS = (AtomicSymbol)sourceA.getSymbol(fromSymbols.toList());
                            AtomicSymbol toS = (AtomicSymbol)targetP.parseToken(to);
                            table.setTranslation(fromS, toS);
                        }
                        ++j;
                    }
                    geneticCodes.put(tableName, table);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new BioError(e, "Couldn't parse TranslationTables.xml");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            rna = (FiniteAlphabet)AlphabetManager.alphabetForName("RNA");
            SymbolList syms = rna.getParser("token").parse("agcu");
            a = syms.symbolAt(1);
            g = syms.symbolAt(2);
            c = syms.symbolAt(3);
            u = syms.symbolAt(4);
            symbolToComplement = new HashMap();
            Symbol gap = rna.getGapSymbol();
            symbolToComplement.put(gap, gap);
            Iterator i = ((SimpleAlphabet)rna).ambiguities();
            while (i.hasNext()) {
                Symbol as = (Symbol)i.next();
                HashSet<Symbol> l = new HashSet<Symbol>();
                FiniteAlphabet fa = (FiniteAlphabet)as.getMatches();
                Iterator j = fa.iterator();
                while (j.hasNext()) {
                    l.add(RNATools.complement((Symbol)j.next()));
                }
                symbolToComplement.put(as, rna.getAmbiguity(l));
            }
            complementTable = new RNAComplementTranslationTable();
            transcriptionTable = new TranscriptionTable();
            geneticCodes = new HashMap();
            RNATools.loadGeneticCodes();
        }
        catch (Throwable t) {
            throw new BioError(t, "Unable to initialize RNATools");
        }
    }
}

